/*
 * Decompiled with CFR 0.152.
 */
package com.hivestone.confluence.plugins.hcms.rest;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPermissionManager;
import com.atlassian.confluence.core.DefaultSaveContext;
import com.atlassian.confluence.core.OperationTrigger;
import com.atlassian.confluence.core.SaveContext;
import com.atlassian.confluence.importexport.ImportExportManager;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.mail.template.ConfluenceMailQueueItem;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.PageUpdateTrigger;
import com.atlassian.confluence.security.ContentPermission;
import com.atlassian.confluence.security.ContentPermissionSet;
import com.atlassian.confluence.security.GateKeeper;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceDescription;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.SpaceType;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.ConfluenceUserImpl;
import com.atlassian.core.task.MultiQueueTaskManager;
import com.atlassian.core.task.Task;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.user.User;
import com.hivestone.confluence.plugins.hcms.rest.HivestoneCopySpaceBandanaContext;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Path(value="/page_hier")
public class CopyPageService {
    private static final Logger LOG = Logger.getLogger(CopyPageService.class);
    private static HashMap<String, String> id_title = new HashMap();
    private static List<String> page_with_id = new ArrayList<String>();
    private PageManager pageManager;
    private PermissionManager permissionManager;
    private SpaceManager spaceManager;
    private ApplicationProperties applicationProperties;
    private final MultiQueueTaskManager taskManager;
    private UserManager userManager;
    private PluginLicenseManager pluginLicenseManager;
    private LabelManager labelManager;
    private ContentPermissionManager contentPermissionManager;
    private AttachmentManager attachmentManager;
    private BandanaManager bandanaManager;
    private ImportExportManager importExportManager;
    private GateKeeper gateKeeper;

    @Autowired
    public CopyPageService(@ComponentImport PageManager pageManager, @ComponentImport PermissionManager permissionManager, @ComponentImport SpaceManager spaceManager, @ComponentImport ApplicationProperties applicationProperties, @ComponentImport MultiQueueTaskManager taskManager, @ComponentImport UserManager userManager, @ComponentImport PluginLicenseManager pluginLicenseManager, @ComponentImport LabelManager labelManager, @ComponentImport ContentPermissionManager contentPermissionManager, @ComponentImport AttachmentManager attachmentManager, @ComponentImport BandanaManager bandanaManager) {
        this.pageManager = pageManager;
        this.permissionManager = permissionManager;
        this.spaceManager = spaceManager;
        this.applicationProperties = applicationProperties;
        this.taskManager = taskManager;
        this.userManager = userManager;
        this.pluginLicenseManager = pluginLicenseManager;
        this.labelManager = labelManager;
        this.contentPermissionManager = contentPermissionManager;
        this.attachmentManager = attachmentManager;
        this.bandanaManager = bandanaManager;
    }

    @GET
    @Path(value="/get_hier/{spacekey}/{pageid}")
    @Produces(value={"application/xml", "application/json"})
    public Response GetPageHierarchy(@PathParam(value="spacekey") String spaceKey, @PathParam(value="pageid") String pageId) {
        LOG.debug((Object)("Got the get_hier request. spacekey:pageid " + spaceKey + ":" + pageId));
        JSONObject tree = new JSONObject();
        JSONArray pageArray = new JSONArray();
        JSONArray hierArray = new JSONArray();
        JSONObject childObject = new JSONObject();
        try {
            Space space = this.spaceManager.getSpace(spaceKey);
            Page rootPage = this.pageManager.getPage(Long.parseLong(pageId));
            List pageList = rootPage.getSortedChildren();
            tree.put("title", (Object)rootPage.getTitle());
            tree.put("id", rootPage.getId());
            int count = 0;
            for (Page page : pageList) {
                int page_pos = count;
                if (page_pos == count) {
                    childObject = this.getChildren(page);
                    pageArray.put((Object)childObject);
                } else {
                    for (Page spage : pageList) {
                        int spage_pos = spage.getPosition();
                        if (spage_pos != count) continue;
                        childObject = this.getChildren(spage);
                        pageArray.put((Object)childObject);
                    }
                }
                ++count;
            }
            tree.put("children", (Object)pageArray);
            hierArray.put((Object)tree);
        }
        catch (JSONException e) {
            LOG.error((Object)"ERROR:get_hier:", (Throwable)e);
        }
        LOG.debug((Object)"get_hier request complete . Sending page list");
        return Response.ok((Object)hierArray.toString()).build();
    }

    public JSONObject getChildren(Page page) {
        JSONArray pageArray = new JSONArray();
        JSONObject tree = new JSONObject();
        JSONObject childObject = new JSONObject();
        try {
            tree.put("title", (Object)page.getTitle());
            tree.put("id", page.getId());
            if (page.hasChildren()) {
                List pageList = page.getSortedChildren();
                int count = 0;
                for (Page cpage : pageList) {
                    int page_pos = count;
                    if (page_pos == count) {
                        childObject = this.getChildren(cpage);
                        pageArray.put((Object)childObject);
                    } else {
                        for (Page spage : pageList) {
                            int spage_pos = spage.getPosition();
                            if (spage_pos != count) continue;
                            childObject = this.getChildren(spage);
                            pageArray.put((Object)childObject);
                        }
                    }
                    ++count;
                }
            }
            tree.put("children", (Object)pageArray);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return tree;
    }

    @POST
    @Path(value="/post_copy_space")
    @Produces(value={"application/xml", "application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response PostCopySpaceRequest(@FormParam(value="spacekey") String spaceKey, @FormParam(value="pageid") String pageId, @FormParam(value="dspacekey") String destSpaceKey, @FormParam(value="spageids") String spageIdList) {
        LOG.debug((Object)("Got the post copy space request. Getting status spacekey:pageid:dspacekey:spageids " + spaceKey + ":" + pageId + ":" + destSpaceKey + ":" + spageIdList));
        Response res = this.CopySpaceRequest(spaceKey, pageId, destSpaceKey, spageIdList);
        return res;
    }

    @GET
    @Path(value="/copy_space/{spacekey}/{pageid}/{dspacekey}/{spageids}")
    @Produces(value={"application/xml", "application/json"})
    public Response CopySpaceRequest(@PathParam(value="spacekey") String spaceKey, @PathParam(value="pageid") String pageId, @PathParam(value="dspacekey") String destSpaceKey, @PathParam(value="spageids") String spageIdList) {
        LOG.debug((Object)("Got the copy space request. Getting status spacekey:pageid:dspacekey:spageids " + spaceKey + ":" + pageId + ":" + destSpaceKey + ":" + spageIdList));
        JSONObject obj = new JSONObject();
        String username = this.userManager.getRemoteUsername();
        UserProfile user = this.userManager.getUserProfile(username);
        Space source_space = this.spaceManager.getSpace(spaceKey);
        Space dest_space = this.spaceManager.getSpace(destSpaceKey.replaceAll("/[^A-Za-z0-9]/", ""));
        Page srootPage = this.pageManager.getPage(Long.parseLong(pageId));
        String pageIdList = spageIdList;
        String dSpaceKey = destSpaceKey.replaceAll("/[^A-Za-z0-9]/", "");
        boolean user_allowed = true;
        if (this.pluginLicenseManager.getLicense().isDefined()) {
            PluginLicense license = (PluginLicense)this.pluginLicenseManager.getLicense().get();
            if (license.getError().isDefined()) {
                String err = "You does not have valid license for 'Copy Page Hierarchy' plugin. Please purchase or renew your license.";
                err = err + "Error:" + ((LicenseError)license.getError().get()).toString();
                this.licenseError(err, user, spaceKey);
                return Response.status((Response.Status)Response.Status.OK).build();
            }
        } else {
            String err = "You does not have valid license for 'Copy Page Hierarchy' plugin. Please purchase or renew your license.";
            this.licenseError(err, user, spaceKey);
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        HivestoneCopySpaceBandanaContext hcsbc = new HivestoneCopySpaceBandanaContext();
        String key = "__perm_level";
        String perm_level = (String)this.bandanaManager.getValue((BandanaContext)hcsbc, key);
        if (perm_level == null) {
            perm_level = "view-perm-user";
        }
        StringBuilder msg = new StringBuilder();
        String[] result = new String[1];
        msg.append("<style>  .text{padding:5px 5px 5px 10px;margin-bottom:4px;color:rgb(72,156,223);}  </style>");
        msg.append("<h3 style=\"text-align:center;\">Confluence Wiki</h3><br/>");
        msg.append("<h3 style=\"text-align:center;\">Copy Space</h3><br/>");
        msg.append("Source Space Page : <a href=\"" + this.applicationProperties.getBaseUrl() + srootPage.getUrlPath() + "\">" + srootPage.getTitle() + "</a><br/><br/><br/>");
        if (perm_level.contains("admin-perm") && !this.permissionManager.hasPermission((User)((ConfluenceUserImpl)this.userManager.resolve(username)), Permission.ADMINISTER, (Object)source_space)) {
            user_allowed = false;
        }
        if (dest_space == null && user_allowed) {
            Space d_space = new Space(dSpaceKey);
            d_space.setName(source_space.getName() + " Copy");
            d_space.setCreator((ConfluenceUser)((ConfluenceUserImpl)this.userManager.resolve(username)));
            SpaceType space_type = source_space.getSpaceType();
            d_space.setSpaceType(space_type);
            List prev_space_perm = source_space.getPermissions();
            ArrayList space_perm = new ArrayList();
            for (SpacePermission perm : prev_space_perm) {
                SpacePermission perm_copy = new SpacePermission(perm);
                d_space.addPermission(perm_copy);
            }
            SpaceDescription space_desc = new SpaceDescription(d_space);
            d_space.setDescription(space_desc);
            Space new_d_space = this.spaceManager.createSpace(d_space);
            if (new_d_space != null) {
                msg.append("<br/> New Space <a href=\"" + this.applicationProperties.getBaseUrl() + new_d_space.getUrlPath() + "\">" + new_d_space.getName() + "</a> created.<br/><br/><br/>");
                Page child = new Page();
                DefaultSaveContext s_context = ((DefaultSaveContext.Builder)((DefaultSaveContext.Builder)((DefaultSaveContext.Builder)DefaultSaveContext.builder().suppressNotifications(true)).suppressAutowatch(true).updateLastModifier(false).suppressEvents(true)).updateTrigger((OperationTrigger)PageUpdateTrigger.LINK_REFACTORING)).build();
                try {
                    Object originalPage;
                    child.setTitle(srootPage.getTitle());
                    child.setSpace(new_d_space);
                    child.setParentPage(new_d_space.getHomePage());
                    String body = srootPage.getBodyAsString();
                    body = body.replaceAll("\"" + spaceKey + "\"", "\"" + dSpaceKey + "\"");
                    body = body.replaceAll("/" + spaceKey + "/", "/" + dSpaceKey + "/");
                    body = body.replaceAll(">" + spaceKey + ",", ">" + dSpaceKey + ",");
                    body = body.replaceAll("," + spaceKey + ",", "," + dSpaceKey + ",");
                    body = body.replaceAll("," + spaceKey + "<", "," + dSpaceKey + "<");
                    body = body.replaceAll(">" + spaceKey + "<", ">" + dSpaceKey + "<");
                    child.setBodyAsString(body);
                    child.setVersion(1);
                    child.setCreator((ConfluenceUser)((ConfluenceUserImpl)this.userManager.resolve(username)));
                    child.setLastModifier((ConfluenceUser)((ConfluenceUserImpl)this.userManager.resolve(username)));
                    child.setCreationDate(child.getCurrentDate());
                    child.setLastModificationDate(child.getCurrentDate());
                    result[0] = "<a href=\"" + this.applicationProperties.getBaseUrl() + "/display/" + dSpaceKey + "/" + srootPage.getTitle() + "\">" + srootPage.getTitle() + "</a>";
                    if (srootPage.isHomePage()) {
                        Page p_home_page = new_d_space.getHomePage();
                        originalPage = (Page)p_home_page.clone();
                        p_home_page.setBodyAsString(body);
                        p_home_page.setTitle(srootPage.getTitle());
                        this.pageManager.saveContentEntity((ContentEntityObject)p_home_page, (ContentEntityObject)originalPage, (SaveContext)s_context);
                        child = p_home_page;
                    } else {
                        this.pageManager.saveContentEntity((ContentEntityObject)child, (SaveContext)s_context);
                        new_d_space.getHomePage().addChild(child);
                    }
                    result[0] = result[0] + "    <font color=\"#00ff00\">&nbsp;&nbsp;&nbsp;&nbsp;COPY PAGE SUCCESS</font> ";
                    List attachments = this.attachmentManager.getLatestVersionsOfAttachments((ContentEntityObject)srootPage);
                    for (Attachment a : attachments) {
                        try {
                            Attachment copy_attachment = new Attachment();
                            copy_attachment.setContentType(a.getContentType());
                            copy_attachment.setFileName(a.getFileName());
                            copy_attachment.setFileSize(a.getFileSize());
                            copy_attachment.setCreationDate(child.getCurrentDate());
                            copy_attachment.setCreator((ConfluenceUser)((ConfluenceUserImpl)this.userManager.resolve(username)));
                            copy_attachment.setLastModificationDate(a.getLastModificationDate());
                            copy_attachment.setLastModifier(a.getLastModifier());
                            child.addAttachment(copy_attachment);
                            Attachment attachment = child.getAttachmentNamed(a.getFileName());
                        }
                        catch (Exception e) {
                            System.out.println(e.getMessage());
                        }
                    }
                    originalPage = (Page)child.clone();
                    this.pageManager.saveContentEntity((ContentEntityObject)child, (ContentEntityObject)originalPage, (SaveContext)s_context);
                    for (Attachment a : attachments) {
                        try {
                            InputStream input = a.getContentsAsStream();
                            Attachment ta = child.getAttachmentNamed(a.getFileName());
                            this.attachmentManager.saveAttachment(ta, null, input, (SaveContext)s_context);
                        }
                        catch (Exception e) {
                            result[0] = result[0] + " Attachment copy issue." + e.getMessage();
                            System.out.println(e.getMessage());
                        }
                    }
                    result[0] = result[0] + "<br/>";
                    result[0] = result[0] + this.addChildrenPages(srootPage.getSortedChildren(), spaceKey, dSpaceKey, child, pageIdList, "&nbsp;&nbsp;&nbsp;&nbsp;");
                }
                catch (Exception e) {
                    result[0] = result[0] + "    <font color=\"ff0000\">&nbsp;&nbsp;&nbsp;&nbsp;ERROR IN COPY PAGE</font> " + e.getMessage() + "<br/>";
                }
            } else {
                result[0] = "";
                msg.append("ERROR:: Creation of Space with provided spacekey '" + dSpaceKey + "' failed. Please re-submit your Copy Space request with unique spacekey.");
            }
        } else {
            result[0] = "";
            if (user_allowed) {
                msg.append("ERROR:: Space with provided spacekey '" + dSpaceKey + "' already exist. Please re-submit your Copy Space request with unique spacekey.");
            } else {
                msg.append("ERROR:: Your site Admin allowed Copy Space function for existing Space Admins only. Please contact your site Admin or Admin of space '" + spaceKey + "' to copy space.");
            }
        }
        msg.append(result[0]);
        this.CorrectPageReferences(dSpaceKey);
        String smtp_from = user.getEmail();
        if (smtp_from.contains("@")) {
            smtp_from = smtp_from.substring(smtp_from.indexOf("@"));
            smtp_from = "noreply" + smtp_from;
        }
        try {
            ConfluenceMailQueueItem copyreportmail = new ConfluenceMailQueueItem(user.getEmail(), "Copy Space [" + spaceKey + "]", msg.toString(), "text/html");
            copyreportmail.setFromName("Confluence Wiki");
            copyreportmail.setFromAddress(smtp_from);
            this.taskManager.addTask("mail", (Task & Serializable)() -> copyreportmail.send());
        }
        catch (Exception e) {
            LOG.error((Object)"ERROR:Copy page hierarchy report:Error in sending mail", (Throwable)e);
        }
        LOG.debug((Object)"Copy space operation complete.");
        return Response.ok((Object)obj.toString()).build();
    }

    @POST
    @Path(value="/post_copy_hier")
    @Produces(value={"application/xml", "application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response PostCopyHierarchyRequest(@FormParam(value="spacekey") String spaceKey, @FormParam(value="pageid") String pageId, @FormParam(value="dspacekey") String destSpaceKey, @FormParam(value="spageids") String spageIdList, @FormParam(value="dpagetitle") String destPageTitle) {
        LOG.debug((Object)("Got the copy hierarchy post request. Getting status spacekey:pageid:dspacekey:spageids:dpagetitle " + spaceKey + ":" + pageId + ":" + destSpaceKey + ":" + spageIdList + ":" + destPageTitle));
        Response res = this.CopyHierarchyRequest(spaceKey, pageId, destSpaceKey, spageIdList, destPageTitle);
        return res;
    }

    @GET
    @Path(value="/copy_hier/{spacekey}/{pageid}/{dspacekey}/{spageids}/{dpagetitle}")
    @Produces(value={"application/xml", "application/json"})
    public Response CopyHierarchyRequest(@PathParam(value="spacekey") String spaceKey, @PathParam(value="pageid") String pageId, @PathParam(value="dspacekey") String destSpaceKey, @PathParam(value="spageids") String spageIdList, @PathParam(value="dpagetitle") String destPageTitle) {
        LOG.debug((Object)("Got the copy hierarchy request. Getting status spacekey:pageid:dspacekey:spageids:dpagetitle " + spaceKey + ":" + pageId + ":" + destSpaceKey + ":" + spageIdList + ":" + destPageTitle));
        destPageTitle = destPageTitle.replaceAll("HIVE_FSLASH", "/");
        destPageTitle = destPageTitle.replaceAll("HIVE_QUEST", "?");
        destPageTitle = destPageTitle.replaceAll("HIVE_AND", "&");
        destPageTitle = destPageTitle.replaceAll("HIVE_HASH", "#");
        destPageTitle = destPageTitle.replace("HIVE_BSLASH", "\\");
        destPageTitle = destPageTitle.replaceAll("HIVE_BSLASH", "\\");
        JSONObject obj = new JSONObject();
        String username = this.userManager.getRemoteUsername();
        UserProfile user = this.userManager.getUserProfile(username);
        Space source_space = this.spaceManager.getSpace(spaceKey);
        Space dest_space = this.spaceManager.getSpace(destSpaceKey);
        Page srootPage = this.pageManager.getPage(Long.parseLong(pageId));
        Page drootPage = this.pageManager.getPage(destSpaceKey, destPageTitle);
        String pageIdList = spageIdList;
        String dSpaceKey = destSpaceKey;
        if (this.pluginLicenseManager.getLicense().isDefined()) {
            PluginLicense license = (PluginLicense)this.pluginLicenseManager.getLicense().get();
            if (license.getError().isDefined()) {
                String err = "You does not have valid license for 'Copy Page Hierarchy' plugin. Please purchase or renew your license.";
                err = err + "Error:" + ((LicenseError)license.getError().get()).toString();
                this.licenseError(err, user, spaceKey);
                return Response.status((Response.Status)Response.Status.OK).build();
            }
        } else {
            String err = "You does not have valid license for 'Copy Page Hierarchy' plugin. Please purchase or renew your license.";
            this.licenseError(err, user, spaceKey);
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        StringBuilder msg = new StringBuilder();
        String[] result = new String[1];
        msg.append("<style>  .text{padding:5px 5px 5px 10px;margin-bottom:4px;color:rgb(72,156,223);}  </style>");
        msg.append("<h3 style=\"text-align:center;\">Confluence CMS</h3><br/>");
        msg.append("<h3 style=\"text-align:center;\">Copy Page Hierarchy</h3><br/>");
        msg.append("Source Page : <a href=\"" + this.applicationProperties.getBaseUrl() + srootPage.getUrlPath() + "\">" + srootPage.getTitle() + "</a><br/>");
        if (drootPage != null) {
            msg.append("Destination Page : <a href=\"" + this.applicationProperties.getBaseUrl() + drootPage.getUrlPath() + "\">" + drootPage.getTitle() + "</a><br/><br/><br/>");
            String body = srootPage.getBodyAsString();
            String pageTitle = srootPage.getTitle();
            Page dup_page = this.pageManager.getPage(dSpaceKey, srootPage.getTitle());
            if (dup_page != null) {
                pageTitle = pageTitle + " (Copy)";
            }
            Page child = new Page();
            List attachments = this.attachmentManager.getLatestVersionsOfAttachments((ContentEntityObject)srootPage);
            DefaultSaveContext s_context = ((DefaultSaveContext.Builder)((DefaultSaveContext.Builder)((DefaultSaveContext.Builder)DefaultSaveContext.builder().suppressNotifications(true)).suppressAutowatch(true).updateLastModifier(false).suppressEvents(true)).updateTrigger((OperationTrigger)PageUpdateTrigger.LINK_REFACTORING)).build();
            try {
                child.setTitle(pageTitle);
                child.setSpace(dest_space);
                child.setParentPage(drootPage);
                child.setLastModificationDate(child.getCurrentDate());
                body = body.replaceAll("\"" + spaceKey + "\"", "\"" + dSpaceKey + "\"");
                body = body.replaceAll("/" + spaceKey + "/", "/" + dSpaceKey + "/");
                body = body.replaceAll(">" + spaceKey + ",", ">" + dSpaceKey + ",");
                body = body.replaceAll("," + spaceKey + ",", "," + dSpaceKey + ",");
                body = body.replaceAll("," + spaceKey + "<", "," + dSpaceKey + "<");
                body = body.replaceAll(">" + spaceKey + "<", ">" + dSpaceKey + "<");
                child.setBodyAsString(body);
                child.setVersion(1);
                child.setCreator((ConfluenceUser)((ConfluenceUserImpl)this.userManager.resolve(username)));
                child.setLastModifier((ConfluenceUser)((ConfluenceUserImpl)this.userManager.resolve(username)));
                child.setCreationDate(child.getCurrentDate());
                if (!srootPage.isHomePage()) {
                    result[0] = "<a href=\"" + this.applicationProperties.getBaseUrl() + "/display/" + dSpaceKey + "/" + pageTitle + "\">" + pageTitle + "</a>";
                    this.pageManager.saveContentEntity((ContentEntityObject)child, (SaveContext)s_context);
                    List labels = srootPage.getLabels();
                    for (Label label : labels) {
                        this.labelManager.addLabel((Labelable)child, label);
                    }
                    ContentPermissionSet view_perm = srootPage.getContentPermissionSet("View");
                    ContentPermissionSet edit_perm = srootPage.getContentPermissionSet("Edit");
                    HashSet<ContentPermission> view_perm_set = new HashSet<ContentPermission>();
                    if (view_perm != null) {
                        for (Iterator perm : view_perm) {
                            ContentPermission perm_copy = new ContentPermission((ContentPermission)perm);
                            view_perm_set.add(perm_copy);
                        }
                        this.contentPermissionManager.setContentPermissions(view_perm_set, (ContentEntityObject)child, "View");
                    }
                    HashSet<ContentPermission> edit_perm_set = new HashSet<ContentPermission>();
                    if (edit_perm != null) {
                        for (ContentPermission perm : edit_perm) {
                            ContentPermission perm_copy = new ContentPermission(perm);
                            edit_perm_set.add(perm_copy);
                        }
                        this.contentPermissionManager.setContentPermissions(edit_perm_set, (ContentEntityObject)child, "Edit");
                    }
                    drootPage.addChild(child);
                    result[0] = result[0] + "    <font color=\"#00ff00\">&nbsp;&nbsp;&nbsp;&nbsp;COPY PAGE SUCCESS</font> ";
                    for (Attachment a : attachments) {
                        try {
                            Attachment copy_attachment = new Attachment();
                            copy_attachment.setContentType(a.getContentType());
                            copy_attachment.setFileName(a.getFileName());
                            copy_attachment.setFileSize(a.getFileSize());
                            copy_attachment.setCreationDate(child.getCurrentDate());
                            copy_attachment.setCreator((ConfluenceUser)((ConfluenceUserImpl)this.userManager.resolve(username)));
                            copy_attachment.setLastModificationDate(a.getLastModificationDate());
                            copy_attachment.setLastModifier(a.getLastModifier());
                            copy_attachment.setContainer((ContentEntityObject)child);
                            child.addAttachment(copy_attachment);
                            Attachment attachment = (Attachment)copy_attachment.clone();
                        }
                        catch (Exception e) {
                            System.out.println(e.getMessage());
                        }
                    }
                    Page originalPage = (Page)child.clone();
                    this.pageManager.saveContentEntity((ContentEntityObject)child, (ContentEntityObject)originalPage, (SaveContext)s_context);
                    for (Attachment a : attachments) {
                        try {
                            InputStream input = a.getContentsAsStream();
                            Attachment ta = child.getAttachmentNamed(a.getFileName());
                            this.attachmentManager.saveAttachment(ta, null, input, (SaveContext)s_context);
                        }
                        catch (Exception e) {
                            result[0] = result[0] + " &nbsp;&nbsp;&nbsp;&nbsp;Attachment copy issue." + e.getMessage();
                            System.out.println(e.getMessage());
                        }
                    }
                    result[0] = result[0] + "<br/>";
                } else {
                    child = drootPage;
                }
                result[0] = result[0] + this.addChildrenPages(srootPage.getSortedChildren(), spaceKey, dSpaceKey, child, pageIdList, "&nbsp;&nbsp;&nbsp;&nbsp;");
            }
            catch (Exception e) {
                result[0] = result[0] + "    <font color=\"ff0000\">&nbsp;&nbsp;&nbsp;&nbsp;ERROR IN COPY PAGE</font> " + e.getMessage() + "<br/>";
            }
        } else {
            msg.append("There was problem in retreiving page having title '" + destPageTitle + "' of space having spacekey '" + destSpaceKey + "'. Please check if these values are valid and try again with correct values.");
        }
        msg.append(result[0]);
        this.CorrectPageReferences(destSpaceKey);
        String smtp_from = user.getEmail();
        if (smtp_from.contains("@")) {
            smtp_from = smtp_from.substring(smtp_from.indexOf("@"));
            smtp_from = "noreply" + smtp_from;
        }
        try {
            ConfluenceMailQueueItem copyreportmail = new ConfluenceMailQueueItem(user.getEmail(), "Copy Page Hierarchy [" + spaceKey + "]", msg.toString(), "text/html");
            copyreportmail.setFromName("Confluence Wiki");
            copyreportmail.setFromAddress(smtp_from);
            this.taskManager.addTask("mail", (Task & Serializable)() -> copyreportmail.send());
        }
        catch (Exception e) {
            LOG.error((Object)"ERROR:Copy page hierarchy report:Error in sending mail", (Throwable)e);
        }
        LOG.debug((Object)"Copy hierarchy operation complete.");
        return Response.ok((Object)obj.toString()).build();
    }

    public String addChildrenPages(List<Page> childPageList, String spaceKey, String destSpaceKey, Page root, String pageIdList, String indent) {
        String username = this.userManager.getRemoteUsername();
        UserProfile user = this.userManager.getUserProfile(username);
        String result = "";
        int position = 1;
        for (Page page : childPageList) {
            String pageId = page.getIdAsString();
            if (!pageIdList.contains(pageId + "_")) continue;
            root = this.pageManager.getPage(destSpaceKey, root.getTitle());
            String body = page.getBodyAsString();
            String pageTitle = page.getTitle();
            String[] orig_page_ids = pageIdList.split("_");
            boolean page_need_update = false;
            for (String orig_page_id : orig_page_ids) {
                if (orig_page_id.length() <= 5 || !body.contains(orig_page_id)) continue;
                page_need_update = true;
                Page orig_page = this.pageManager.getPage(Long.parseLong(orig_page_id));
                id_title.put(orig_page_id, orig_page.getTitle());
            }
            Page dup_page = this.pageManager.getPage(destSpaceKey, page.getTitle());
            if (dup_page != null) {
                pageTitle = pageTitle + " (Copy)";
            }
            if (page_need_update) {
                page_with_id.add(pageTitle);
            }
            Page child = new Page();
            DefaultSaveContext s_context = ((DefaultSaveContext.Builder)((DefaultSaveContext.Builder)((DefaultSaveContext.Builder)DefaultSaveContext.builder().suppressNotifications(true)).suppressAutowatch(true).updateLastModifier(false).suppressEvents(true)).updateTrigger((OperationTrigger)PageUpdateTrigger.LINK_REFACTORING)).build();
            List attachments = this.attachmentManager.getLatestVersionsOfAttachments((ContentEntityObject)page);
            try {
                Iterator perm2;
                child.setTitle(pageTitle);
                child.setSpace(this.spaceManager.getSpace(destSpaceKey));
                child.setParentPage(root);
                body = body.replaceAll("\"" + spaceKey + "\"", "\"" + destSpaceKey + "\"");
                body = body.replaceAll("/" + spaceKey + "/", "/" + destSpaceKey + "/");
                body = body.replaceAll(">" + spaceKey + ",", ">" + destSpaceKey + ",");
                body = body.replaceAll("," + spaceKey + ",", "," + destSpaceKey + ",");
                body = body.replaceAll("," + spaceKey + "<", "," + destSpaceKey + "<");
                body = body.replaceAll(">" + spaceKey + "<", ">" + destSpaceKey + "<");
                child.setBodyAsString(body);
                child.setVersion(1);
                child.setPosition(Integer.valueOf(position));
                child.setCreator((ConfluenceUser)((ConfluenceUserImpl)this.userManager.resolve(username)));
                child.setLastModifier((ConfluenceUser)((ConfluenceUserImpl)this.userManager.resolve(username)));
                child.setCreationDate(child.getCurrentDate());
                child.setLastModificationDate(child.getCurrentDate());
                result = result + indent + "<a href=\"" + this.applicationProperties.getBaseUrl() + "/display/" + destSpaceKey + "/" + pageTitle + "\">" + pageTitle + "</a>";
                this.pageManager.saveContentEntity((ContentEntityObject)child, (SaveContext)s_context);
                List labels = page.getLabels();
                for (Label label : labels) {
                    this.labelManager.addLabel((Labelable)child, label);
                }
                ContentPermissionSet view_perm = page.getContentPermissionSet("View");
                ContentPermissionSet edit_perm = page.getContentPermissionSet("Edit");
                HashSet<ContentPermission> view_perm_set = new HashSet<ContentPermission>();
                if (view_perm != null) {
                    for (Iterator perm2 : view_perm) {
                        ContentPermission perm_copy = new ContentPermission((ContentPermission)perm2);
                        view_perm_set.add(perm_copy);
                    }
                    this.contentPermissionManager.setContentPermissions(view_perm_set, (ContentEntityObject)child, "View");
                }
                HashSet<ContentPermission> edit_perm_set = new HashSet<ContentPermission>();
                if (edit_perm != null) {
                    for (ContentPermission perm3 : edit_perm) {
                        ContentPermission perm_copy = new ContentPermission(perm3);
                        edit_perm_set.add(perm_copy);
                    }
                    this.contentPermissionManager.setContentPermissions(edit_perm_set, (ContentEntityObject)child, "Edit");
                }
                root.addChild(child);
                ++position;
                result = result + "    <font color=\"#00ff00\">&nbsp;&nbsp;&nbsp;&nbsp;COPY PAGE SUCCESS</font> ";
                perm2 = attachments.iterator();
                while (perm2.hasNext()) {
                    Attachment a = (Attachment)perm2.next();
                    try {
                        Attachment copy_attachment = new Attachment();
                        copy_attachment.setContentType(a.getContentType());
                        copy_attachment.setFileName(a.getFileName());
                        copy_attachment.setFileSize(a.getFileSize());
                        copy_attachment.setCreationDate(child.getCurrentDate());
                        copy_attachment.setCreator((ConfluenceUser)((ConfluenceUserImpl)this.userManager.resolve(username)));
                        copy_attachment.setLastModificationDate(a.getLastModificationDate());
                        copy_attachment.setLastModifier(a.getLastModifier());
                        copy_attachment.setContainer((ContentEntityObject)child);
                        child.addAttachment(copy_attachment);
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                    }
                }
                Page originalPage = (Page)child.clone();
                this.pageManager.saveContentEntity((ContentEntityObject)child, (ContentEntityObject)originalPage, (SaveContext)s_context);
                for (Attachment a : attachments) {
                    try {
                        InputStream input = a.getContentsAsStream();
                        Attachment ta = child.getAttachmentNamed(a.getFileName());
                        this.attachmentManager.saveAttachment(ta, null, input, (SaveContext)s_context);
                    }
                    catch (Exception e) {
                        result = result + " &nbsp;&nbsp;&nbsp;&nbsp;Attachment copy issue." + e.getMessage();
                    }
                }
                result = result + "<br/>";
                result = result + this.addChildrenPages(page.getSortedChildren(), spaceKey, destSpaceKey, child, pageIdList, indent + "&nbsp;&nbsp;&nbsp;&nbsp;");
            }
            catch (Exception e) {
                result = result + "    <font color=\"ff0000\">&nbsp;&nbsp;&nbsp;&nbsp;ERROR IN COPY PAGE</font> " + e.getMessage() + "<br/>";
            }
        }
        return result;
    }

    public String CorrectPageReferences(String dest_spaceKey) {
        try {
            for (String page_title : page_with_id) {
                Page page = this.pageManager.getPage(dest_spaceKey, page_title);
                Page original_page = (Page)page.clone();
                String body = page.getBodyAsString();
                for (Map.Entry<String, String> set : id_title.entrySet()) {
                    String old_page_id = set.getKey();
                    String dest_page_title = set.getValue();
                    Page new_page = this.pageManager.getPage(dest_spaceKey, dest_page_title);
                    if (new_page == null) {
                        new_page = this.pageManager.getPage(dest_spaceKey, dest_page_title + " (Copy)");
                    }
                    String new_page_id = new_page.getIdAsString();
                    body = body.replaceAll(old_page_id, new_page_id);
                }
                page.setBodyAsString(body);
                this.pageManager.saveContentEntity((ContentEntityObject)page, (ContentEntityObject)original_page, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        page_with_id.clear();
        id_title.clear();
        return "";
    }

    @POST
    @Path(value="/post_delete_hier")
    @Produces(value={"application/xml", "application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response PostDeleteHierarchyRequest(@FormParam(value="spacekey") String spaceKey, @FormParam(value="pageid") String pageId, @FormParam(value="spageids") String spageIdList) {
        LOG.debug((Object)("Got the post delete hierarchy request. Getting status spacekey:pageid:spageids " + spaceKey + ":" + pageId + ":" + spageIdList));
        Response res = this.DeleteHierarchyRequest(spaceKey, pageId, spageIdList);
        return res;
    }

    @GET
    @Path(value="/delete_hier/{spacekey}/{pageid}/{spageids}")
    @Produces(value={"application/xml", "application/json"})
    public Response DeleteHierarchyRequest(@PathParam(value="spacekey") String spaceKey, @PathParam(value="pageid") String pageId, @PathParam(value="spageids") String spageIdList) {
        LOG.debug((Object)("Got the delete hierarchy request. Getting status spacekey:pageid:spageids " + spaceKey + ":" + pageId + ":" + spageIdList));
        JSONObject obj = new JSONObject();
        String username = this.userManager.getRemoteUsername();
        UserProfile user = this.userManager.getUserProfile(username);
        StringBuilder msg = new StringBuilder();
        if (this.pluginLicenseManager.getLicense().isDefined()) {
            PluginLicense license = (PluginLicense)this.pluginLicenseManager.getLicense().get();
            if (license.getError().isDefined()) {
                String err = "You does not have valid license for 'Copy Page Hierarchy' plugin. Please purchase or renew your license.";
                err = err + "Error:" + ((LicenseError)license.getError().get()).toString();
                this.licenseError(err, user, spaceKey);
                return Response.status((Response.Status)Response.Status.OK).build();
            }
        } else {
            String err = "You does not have valid license for 'Copy Page Hierarchy' plugin. Please purchase or renew your license.";
            this.licenseError(err, user, spaceKey);
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        String[] result = new String[1];
        msg.append("<style>  .text{padding:5px 5px 5px 10px;margin-bottom:4px;color:rgb(72,156,223);}  </style>");
        msg.append("<h3 style=\"text-align:center;\">Confluence CMS</h3><br/>");
        msg.append("<h3 style=\"text-align:center;\">Delete Page Hierarchy</h3><br/>");
        Page rootPage = this.pageManager.getPage(Long.parseLong(pageId));
        msg.append("Source Page : <a href=\"" + this.applicationProperties.getBaseUrl() + rootPage.getUrlPath() + "\">" + rootPage.getTitle() + "</a><br/><br/><br/>");
        result[0] = this.deletePages(rootPage, spageIdList, username, "&nbsp;&nbsp;");
        msg.append(result[0]);
        String smtp_from = user.getEmail();
        if (smtp_from.contains("@")) {
            smtp_from = smtp_from.substring(smtp_from.indexOf("@"));
            smtp_from = "noreply" + smtp_from;
        }
        try {
            ConfluenceMailQueueItem copyreportmail = new ConfluenceMailQueueItem(user.getEmail(), "Delete Page Hierarchy [" + spaceKey + "]", msg.toString(), "text/html");
            copyreportmail.setFromName("Confluence Wiki");
            copyreportmail.setFromAddress(smtp_from);
            this.taskManager.addTask("mail", (Task & Serializable)() -> copyreportmail.send());
        }
        catch (Exception e) {
            LOG.error((Object)"ERROR:Copy page hierarchy report:Error in sending mail", (Throwable)e);
        }
        LOG.debug((Object)"Delete hierarchy operation complete.");
        return Response.ok((Object)obj.toString()).build();
    }

    public String deletePages(Page rootPage, String pageIdList, String username, String indent) {
        String child_result;
        String result;
        block16: {
            result = "";
            child_result = "";
            if (rootPage.hasChildren()) {
                List children = rootPage.getSortedChildren();
                for (Page child : children) {
                    child_result = child_result + this.deletePages(child, pageIdList, username, indent + "&nbsp;&nbsp;&nbsp;&nbsp;");
                }
                long id = rootPage.getContentId().asLong();
                if (pageIdList.contains(String.valueOf(id))) {
                    result = result + indent + "<a href=\"" + this.applicationProperties.getBaseUrl() + rootPage.getUrlPath() + "\">" + rootPage.getTitle() + "</a>";
                    try {
                        if (this.permissionManager.hasPermission((User)((ConfluenceUserImpl)this.userManager.resolve(username)), Permission.REMOVE, (Object)rootPage)) {
                            if (rootPage.hasChildren()) {
                                List remain_children = rootPage.getSortedChildren();
                                for (Page rem_child : remain_children) {
                                    this.pageManager.movePageAsChild(rem_child, rootPage.getParent());
                                    rootPage.getParent().addChild(rem_child);
                                    rem_child.setParent(rootPage.getParent());
                                }
                            }
                            rootPage.trash();
                            this.pageManager.removeContentEntity((ContentEntityObject)rootPage);
                            result = result + "    <font color=\"#00ff00\">&nbsp;&nbsp;&nbsp;&nbsp;DELETE PAGE SUCCESS</font> ";
                            break block16;
                        }
                        result = result + "    <font color=\"ff0000\">NO DELETE PERMISSION</font><br/>";
                    }
                    catch (Exception e) {
                        result = result + "    <font color=\"ff0000\">&nbsp;&nbsp;&nbsp;&nbsp;ERROR IN DELETE PAGE</font> " + e.getMessage() + "<br/>";
                    }
                }
            } else {
                long id = rootPage.getContentId().asLong();
                if (pageIdList.contains(String.valueOf(id))) {
                    result = result + indent + "<a href=\"" + this.applicationProperties.getBaseUrl() + rootPage.getUrlPath() + "\">" + rootPage.getTitle() + "</a>";
                    try {
                        if (this.permissionManager.hasPermission((User)((ConfluenceUserImpl)this.userManager.resolve(username)), Permission.REMOVE, (Object)rootPage)) {
                            if (rootPage.hasChildren()) {
                                List remain_children = rootPage.getSortedChildren();
                                for (Page rem_child : remain_children) {
                                    this.pageManager.movePageAsChild(rem_child, rootPage.getParent());
                                    rootPage.getParent().addChild(rem_child);
                                    rem_child.setParent(rootPage.getParent());
                                }
                            }
                            rootPage.trash();
                            this.pageManager.removeContentEntity((ContentEntityObject)rootPage);
                            result = result + "    <font color=\"#00ff00\">DELETE PAGE SUCCESS</font> ";
                        } else {
                            result = result + "    <font color=\"ff0000\">NO DELETE PERMISSION</font><br/>";
                        }
                    }
                    catch (Exception e) {
                        result = result + "    <font color=\"ff0000\">ERROR IN DELETE PAGE</font> " + e.getMessage() + "<br/>";
                    }
                }
            }
        }
        result = result + "<br/>";
        result = result + child_result;
        return result;
    }

    @GET
    @Path(value="/copy_delete/status")
    @Produces(value={"application/xml", "application/json"})
    public Response Status() {
        JSONObject obj = new JSONObject();
        return Response.ok((Object)obj.toString()).build();
    }

    @GET
    @Path(value="/settings/fetch")
    @Produces(value={"application/xml", "application/json"})
    public Response Settings() {
        JSONObject obj = new JSONObject();
        HivestoneCopySpaceBandanaContext hcsbc = new HivestoneCopySpaceBandanaContext();
        String key = "__perm_level";
        String perm_level = (String)this.bandanaManager.getValue((BandanaContext)hcsbc, key);
        if (perm_level == null) {
            perm_level = "view-perm-user";
        }
        try {
            obj.put("copyspace-perm-user", (Object)perm_level);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return Response.ok((Object)obj.toString()).build();
    }

    @POST
    @Path(value="/settings/save")
    @Produces(value={"application/xml", "application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response SettingsSave(@FormParam(value="copyspace-perm-user") String permUser, @FormParam(value="user-perm") String user) {
        HivestoneCopySpaceBandanaContext hcsbc = new HivestoneCopySpaceBandanaContext();
        String key = "__perm_level";
        this.bandanaManager.setValue((BandanaContext)hcsbc, key, (Object)user);
        JSONObject obj = new JSONObject();
        return Response.ok((Object)obj.toString()).build();
    }

    private void licenseError(String msg, UserProfile user, String spaceKey) {
        String smtp_from = user.getEmail();
        if (smtp_from.contains("@")) {
            smtp_from = smtp_from.substring(smtp_from.indexOf("@"));
            smtp_from = "noreply" + smtp_from;
        }
        try {
            ConfluenceMailQueueItem copyreportmail = new ConfluenceMailQueueItem(user.getEmail(), "Copy Page Hierarchy [" + spaceKey + "]", msg.toString(), "text/html");
            copyreportmail.setFromName("Confluence Wiki");
            copyreportmail.setFromAddress(smtp_from);
            this.taskManager.addTask("mail", (Task & Serializable)() -> copyreportmail.send());
            LOG.debug((Object)"Copy Page Hierarchy Mail Sending Done");
        }
        catch (Exception e) {
            LOG.error((Object)"ERROR:Copy Page Hierarchy:Error in sending mail", (Throwable)e);
        }
    }

    public void setBandanaManager(BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
        LOG.debug((Object)("BandanaManager: " + this.bandanaManager));
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
        LOG.debug((Object)("PageManager: " + this.pageManager));
    }

    public void setLabelManager(LabelManager labelManager) {
        this.labelManager = labelManager;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public void setContentPermissionManager(ContentPermissionManager contentPermissionManager) {
        this.contentPermissionManager = contentPermissionManager;
    }

    public void setAttachmentManager(AttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
        LOG.debug((Object)("AttachmentManager: " + this.attachmentManager));
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
        LOG.debug((Object)("SpaceManager: " + this.spaceManager));
    }

    public void setImportExportManager(ImportExportManager importExportManager) {
        this.importExportManager = importExportManager;
        LOG.debug((Object)("ImportExportManager: " + this.importExportManager));
    }

    public void setApplicationProperties(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
        LOG.debug((Object)("ApplicationProperties: " + this.applicationProperties));
    }

    public void setGateKeeper(GateKeeper gateKeeper) {
        this.gateKeeper = gateKeeper;
        LOG.debug((Object)("GateKeeper: " + this.gateKeeper));
    }

    public void setPluginLicenseManager(PluginLicenseManager pluginLicenseManager) {
        this.pluginLicenseManager = pluginLicenseManager;
        LOG.debug((Object)("PluginLicenseManager: " + this.pluginLicenseManager));
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
        LOG.debug((Object)("UserManager: " + this.userManager));
    }
}

