/*
 * Decompiled with CFR 0.152.
 */
package com.hivestone.confluence.plugins.hcms.macro;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugins.osgi.javaconfig.OsgiServices;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionalMultiExcerptMacro
extends BaseMacro
implements Macro {
    private static Logger LOG = LoggerFactory.getLogger(ConditionalMultiExcerptMacro.class);
    private final PageManager pageManager;
    private final SpaceManager spaceManager;
    private AttachmentManager attachmentManager;
    private final BandanaManager bandanaManager;
    private final PluginLicenseManager pluginLicenseManager;

    public ConditionalMultiExcerptMacro(PageManager pageManager, SpaceManager spaceManager, AttachmentManager attachmentManager, BandanaManager bandanaManager, PluginLicenseManager pluginLicenseManager) {
        this.pageManager = pageManager;
        this.spaceManager = spaceManager;
        this.attachmentManager = attachmentManager;
        this.bandanaManager = bandanaManager;
        this.pluginLicenseManager = pluginLicenseManager;
    }

    public ConditionalMultiExcerptMacro() {
        this.pageManager = OsgiServices.importOsgiService(PageManager.class);
        this.bandanaManager = OsgiServices.importOsgiService(BandanaManager.class);
        this.spaceManager = OsgiServices.importOsgiService(SpaceManager.class);
        this.attachmentManager = OsgiServices.importOsgiService(AttachmentManager.class);
        this.pluginLicenseManager = OsgiServices.importOsgiService(PluginLicenseManager.class);
    }

    public boolean isInline() {
        return true;
    }

    public boolean hasBody() {
        return true;
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.ALL;
    }

    public String execute(Map params, String body, RenderContext renderContext) throws MacroException {
        String cmeCond_name;
        String result = "";
        if (this.pluginLicenseManager.getLicense().isDefined()) {
            PluginLicense license = (PluginLicense)this.pluginLicenseManager.getLicense().get();
            if (license.getError().isDefined()) {
                String err = "You does not have valid license for 'Conditional MultiExcerpt' plugin. Please purchase or renew your license.<br />";
                err = err + "Error:" + ((LicenseError)license.getError().get()).toString();
                return err;
            }
        } else {
            String err = "You does not have valid license for 'Conditional MultiExcerpt' plugin. Please purchase or renew your license.<br />";
            return err;
        }
        String condition_name = (String)params.get("conname");
        String show_where = (String)params.get("whereused");
        if (show_where == null) {
            show_where = "False";
        }
        PageContext page_cont = (PageContext)renderContext;
        String spaceKey = page_cont.getSpaceKey();
        ConfluenceBandanaContext cfc = new ConfluenceBandanaContext(spaceKey);
        String manualDir = spaceKey;
        String spaceMap = "";
        String variables = "";
        if (this.bandanaManager != null) {
            spaceMap = (String)this.bandanaManager.getValue((BandanaContext)cfc, "hivestone-cond-spacemap");
            variables = (String)this.bandanaManager.getValue((BandanaContext)cfc, "hivestone-cond-variable");
        }
        String toShow_s = "KEY_";
        String toShow_e = "KEY_";
        if (manualDir == null) {
            manualDir = "";
        } else {
            toShow_s = toShow_s + manualDir + "_ST";
            toShow_e = toShow_e + manualDir + "_END";
        }
        if (spaceMap == null) {
            spaceMap = "";
        }
        if (variables == null) {
            variables = "";
        }
        if ((cmeCond_name = (String)params.get("conname")) == null) {
            cmeCond_name = "";
        }
        cmeCond_name = cmeCond_name.replaceAll("\\s*", "");
        String color = (String)params.get("color");
        if (color == null) {
            color = "";
        }
        color = color.equals("Green") ? "<span class=\"hivestonegreenfont\">" : (color.equals("Red") ? "<span class=\"hivestoneredfont\">" : (color.equals("Blue") ? "<span class=\"hivestonebluefont\">" : "<span class=\"hivestonedefaultfont\">"));
        String toHide = "KEY_(((?!_END).)+)_END";
        String[] mappart = spaceMap.split(";");
        result = body;
        return result.toString();
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.RICH_TEXT;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    public String execute(Map<String, String> params, String body, ConversionContext conversionContext) throws MacroExecutionException {
        int i;
        String show_where;
        String cmeCond_name;
        String result = "";
        String spaceKey = conversionContext.getSpaceKey();
        if (this.pluginLicenseManager.getLicense().isDefined()) {
            PluginLicense license = (PluginLicense)this.pluginLicenseManager.getLicense().get();
            if (license.getError().isDefined()) {
                String err = "You does not have valid license for 'Conditional MultiExcerpt' plugin. Please purchase or renew your license.<br />";
                err = err + "Error:" + ((LicenseError)license.getError().get()).toString();
                return err;
            }
        } else {
            String err = "You does not have valid license for 'Conditional MultiExcerpt' plugin. Please purchase or renew your license.<br />";
            return err;
        }
        ConfluenceBandanaContext cfc = new ConfluenceBandanaContext(spaceKey);
        String manualDir = spaceKey;
        String spaceMap = "";
        String variables = "";
        if (this.bandanaManager != null) {
            spaceMap = (String)this.bandanaManager.getValue((BandanaContext)cfc, "hivestone-cond-spacemap");
            variables = (String)this.bandanaManager.getValue((BandanaContext)cfc, "hivestone-cond-variable");
        }
        String toShow_s = "KEY_";
        String toShow_e = "KEY_";
        if (manualDir == null) {
            manualDir = "";
        } else {
            toShow_s = toShow_s + manualDir + "_ST";
            toShow_e = toShow_e + manualDir + "_END";
        }
        if (spaceMap == null) {
            spaceMap = "";
        }
        if (variables == null) {
            variables = "";
        }
        if ((cmeCond_name = params.get("conname")) == null) {
            cmeCond_name = "";
        }
        if ((show_where = params.get("whereused")) == null) {
            show_where = "False";
        }
        cmeCond_name = cmeCond_name.replaceAll("\\s*", "");
        String color = params.get("color");
        if (color == null) {
            color = "";
        }
        color = color.equals("Green") ? "<span class=\"hivestonegreenfont\">" : (color.equals("Red") ? "<span class=\"hivestoneredfont\">" : (color.equals("Blue") ? "<span class=\"hivestonebluefont\">" : ""));
        String toHide = "KEY_(((?!_END).)+)_END";
        String[] mappart = spaceMap.split(";");
        result = body;
        ContentEntityObject page_cont = conversionContext.getEntity();
        result = result.replaceAll(toShow_s, color);
        result = color.isEmpty() ? result.replaceAll(toShow_e, "") : result.replaceAll(toShow_e, "</span>");
        for (int i2 = 0; i2 <= mappart.length - 1; ++i2) {
            if (!mappart[i2].contains(manualDir + ":")) continue;
            toShow_s = mappart[i2];
            toShow_s = toShow_s.replaceAll(manualDir + ":", "");
            toShow_e = "KEY_" + toShow_s + "_END";
            toShow_s = "KEY_" + toShow_s + "_ST";
            result = result.replaceAll(toShow_s, color);
            result = color.isEmpty() ? result.replaceAll(toShow_e, "") : result.replaceAll(toShow_e, "</span>");
        }
        result = result.replaceAll(toHide, "");
        String[] var_values = variables.split("\\n");
        String[] vars = new String[var_values.length];
        HashMap<String, String> map = new HashMap<String, String>();
        for (i = 0; i <= var_values.length - 1; ++i) {
            if (var_values[i] == null || var_values[i].isEmpty() || !var_values[i].contains(":")) continue;
            String[] var_value = var_values[i].split(":");
            String var = var_value[0].trim();
            var = var.replace("$", "\\Q$");
            String value = var_value[1].trim();
            vars[i] = var;
            map.put(var, value);
        }
        Arrays.sort(vars, new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                if (s1 != null && !s1.isEmpty() && s2 != null && !s2.isEmpty()) {
                    return s2.length() - s1.length();
                }
                return 0;
            }
        });
        for (i = 0; i <= vars.length - 1; ++i) {
            if (vars[i] == null || vars[i].isEmpty() || !map.containsKey(vars[i])) continue;
            result = result.replaceAll(vars[i], (String)map.get(vars[i]));
        }
        if (result.matches(".*?<tr>\\s*<td (?!>).*>\\s*(<code>\\s*</code>)?\\s*(<em>\\s*</em>)?\\s*</td>\\s*<td(?!>).*>\\s*(<code>\\s*</code>)?\\s*(<em>\\s*</em>)?\\s*</td>\\s*</tr>.*")) {
            result = result.replaceAll("<tr><td (((?!>).)+)>\\s*(<code>\\s*</code>)?\\s*(<em>\\s*</em>)?\\s*</td><td (((?!>).)+)>\\s*(<code>\\s*</code>)?\\s*(<em>\\s*</em>)?\\s*</td></tr>", "");
        }
        result = result.replaceAll("<a href=(((?!>).)+)></a>", "");
        if (show_where.contains("True")) {
            String where_used = "<br/><div id=\"ss_no_output\"><h6>Where Used</h6><ul>";
            String whereused_key = cmeCond_name + "@@" + spaceKey + ":" + conversionContext.getEntity().getDisplayTitle();
            String whereused_val = (String)this.bandanaManager.getValue((BandanaContext)cfc, whereused_key);
            if (whereused_val != null) {
                String[] wu_values = whereused_val.split("__SEP__");
                for (int i3 = 0; i3 < wu_values.length; ++i3) {
                    String title;
                    String wu_value = wu_values[i3];
                    if (wu_value.isEmpty()) continue;
                    String[] val_parts = wu_value.split("@@");
                    String user = val_parts[0];
                    String space_page = val_parts[1];
                    String space = space_page.substring(0, space_page.indexOf(":"));
                    Page page = this.pageManager.getPage(space, title = space_page.substring(space_page.indexOf(":") + 1));
                    if (page == null) continue;
                    String body_text = page.getBodyAsString();
                    if (!body_text.contains("\"conname\">" + cmeCond_name + "<")) {
                        String new_whereused_val = whereused_val.replace(wu_value, "");
                        new_whereused_val = new_whereused_val.replace("__SEP____SEP__", "__SEP__");
                        this.bandanaManager.setValue((BandanaContext)cfc, whereused_key, (Object)new_whereused_val);
                        continue;
                    }
                    where_used = where_used + "<li><a href=\"/display/" + space + "/" + title + "\">" + title + "</a> [" + space + "] [" + user + "]</li>";
                }
            }
            where_used = where_used + "</ul></div>";
            result = result + where_used;
        }
        return result.toString();
    }
}

