var hcms_cme = {};

AJS.toInit(function() {                                                                                                      
  var conditionPanelContent = '<form id="form-page" action="#" method="post" class="aui">' + 
    '<div class="field-group">' + 
    '<label for="hivestone-cond-spacemap">SpaceKey Keyword Map (spaceKey:Keyword)</label>' +
    '<textarea class="textarea" id="hivestone-cond-spacemap" name="spacemap" style="max-width:600px;height:60px;" title="SpaceKey Keyword Map"></textarea>' +
    '<span class="spacemap"><br/>SpaceKey to Keyword map. For multiple conditional keywords, use semi-colon as delimeter.(ex- spaceKey1:prodA;spaceKey1:version1) <br/>If keyword is prodA for spaceKey1, conditional content in conditional multi-excerpt would be provided as "KEY_prodA_ST some conditional text KEY_prodA_END KEY_prodB_ST other conditional text KEY_prodB_END". <br/>In this case "some conditional text" will be displayed only in space whose spacekey is mapped to prodA and "other conditional text" would be displayed only in space whose spacekey is mapped to prodB. Content outside the tags will be displayed as it is wherever conditional multi-excerpt is included.</span><br/>' + 
    '<label for="hivestone-cond-variable">Variables ($Key:Value)</label>' +
    '<textarea class="textarea" id="hivestone-cond-variable" name="variable" style="max-width:500px;height:80px;" title="Variables"></textarea>' +
    '<span class="variable"><br/>Provide variable and value pair, one entry per line. Ex- $PROD:MyProduct</span>' +
    '</div>' +
    '</form>';                                                                                                               
  var tocPanelContent = '<form id="form-toc" action="#" method="post" class="aui top-label">' +
    '<div class="field-group">' + 
    '<label for="cond-head-level">TOC Heading Level </label>' +
    '<select class="select" id="cond-head-level" name="head-level" title="Heaging Level">' +
    '<option value="Heading 1">Heading 1</option>' + 
    '<option value="Heading 2">Heading 2</option>' +
    '<option value="Heading 3">Heading 3</option>' +
    '<option value="Heading 4">Heading 4</option>' +
    '</select>' + 
    '<span class="description">Select the Level of heading</span>' + 
    '</div>' + 
    '</form>';                                                                                                               
  var cond_dialog = new AJS.Dialog({width:660, height:540, id:"map-dialog", closeOnOutsideClick: false});
  hcms_cme.cond.dialog = cond_dialog;                                                                                            
  cond_dialog.addHeader("Condition Keyword map");
  cond_dialog.addPanel("Pages", conditionPanelContent, '', 'condition-panel-page'); 
  //meta_dialog.addPanel("TOC", tocPanelContent, '', 'condition-panel-toc'); 
                                                                            
  cond_dialog.addButton('Save', function(dialog, page) {
        hcms_cme.cond.save();
        dialog.hide();
  }, 'button-save'); 
                    
  cond_dialog.addButton('Cancel', function(dialog, page) {
    hcms_cme.cond.cancel();
    dialog.hide();  
  }, 'button-cancel');
                     
  cond_dialog.gotoPanel(0, 0);
                             
  AJS.$('#hcms_cme_cond-keyword-map').click(function(e) {
    e.preventDefault(); 
    //hcms_cme.cond.show();
    hcms_cme.cond.reset(); 
    //hcms_cme.cond.fetch();
    hcms_cme.cond.checkLoginStatus(); 
  });  

  $(document).on('focusout', '#macro-param-sspace', function(){
    setTimeout(function() {
      var spaceKey = $('#macro-param-sspace').val();
      if(!spaceKey) {
        spaceKey = AJS.Meta.get('space-key');
	$('#macro-param-source').trigger('focusout');
      }
      $('#macro-param-source').attr('data-spacekey', spaceKey);
    }, 300);
  });

});
                                                                                                                             
hcms_cme.cond = {};
hcms_cme.cond.loginMsg = "Your session is expired. You must re-login in to access the options in the TechAuth menu.";
hcms_cme.cond.reset = function() { 
  hcms_cme.cond.dialog.gotoPanel(0, 0);
}   
   
hcms_cme.cond.show = function() {
  hcms_cme.cond.dialog.show();  
}   
   
hcms_cme.cond.checkLoginStatus = function() {
jQuery.ajax({  
  "type": "GET", 
  "url": AJS.contextPath() + "/rest/hcms_cme/1.0/condition/status",
  "dataType": "json", 
  "beforeSend": function() { 
  }, 
  "success": function(data, result) { 
    if(result === 'success') { 
      hcms_cme.cond.show();   
      hcms_cme.cond.fetch(); 
    }                       
  },   
  "error": function(jqXHR){
   alert(hcms_cme.cond.loginMsg); 
   console.log("Error:"+JSON.stringify(jqXHR)); 
   return false;  
  },  
  "complete": function() {
  }  
}); 
}  
  
hcms_cme.cond.fetch = function() {  
  AJS.$.ajax({ 
    "type": "GET", 
    "url": AJS.contextPath() + "/rest/hcms_cme/1.0/condition/fetch/" + 
      AJS.params.pageId, 
    "dataType": "json", 
    "beforeSend": function() { 
      hcms_cme.cond.dialog.disable(); 
      hcms_cme.cond.clean();
      //hcms_cme.toc.fetch(); 
    }, 
    "success": function(data, result) {  
      if(result === 'success') { 
        hcms_cme.cond.fill(data);
      }
    },
  "error": function(jqXHR,textStatus){ 
     //console.log("Error in fetching condition data.Error:"+JSON.stringify(jqXHR));
     //alert(hcms_cme.cond.loginMsg);
     //return false; 
    }, 
 "complete": function() {
      hcms_cme.cond.dialog.enable();  
    } 
  });
}   
   
hcms_cme.cond.clean = function() { 
  AJS.$('#hivestone-cond-spacemap').val('');
  AJS.$('#hivestone-cond-variable').val('');
}
  
hcms_cme.cond.fill = function(cond) { 
                                     
  if(cond === undefined) {
    return; 
  } 
  AJS.$('#hivestone-cond-spacemap').val(cond[0]['hivestone-cond-spacemap']); 
  AJS.$('#hivestone-cond-variable').val(cond[1]['hivestone-cond-variable']);
  for(i = 0; i < cond.length; i++) {
    switch(cond[i].name) {
      case 'hivestone-cond-manual-dir':
         AJS.$('#hivestone-cond-manual-dir').val(cond[i]['hivestone-cond-manual-dir']);
         break; 
      case 'hivestone-cond-pages': 
         AJS.$('#hivestone-cond-pages').val(cond[i]['hivestone-cond-pages']);
         break;
      case 'hivestone-cond-spacemap':
         AJS.$('#hivestone-cond-spacemap').val(cond[i]['hivestone-cond-spacemap']);
         console.log('Got the spacemap value');
         break;
      case 'hivestone-cond-variable':
         AJS.$('#hivestone-cond-variable').val(cond[i]['hivestone-cond-variable']);
         console.log('Got the variables value');
         break;
      default: 
         AJS.$('#footer').append(cond[i].name + '|');
    } 
  }  
}   
   
  
hcms_cme.cond.validate = function() { 
  var errMsg = ''; 
  var showError = false;
                        
  if(jQuery.trim(jQuery('#cond-head-level').val()) === '') { 
    errMsg += ''; 
    //showError = true;
  }   
     
  if(showError) {  
    alert('Set Condition Keyword: ' + errMsg); 
    return false; 
  } else {
    return true;
  }   
}    
    
hcms_cme.cond.save = function() {
    
  AJS.$.ajax({
    "type": "POST",
    "contentType": "application/x-www-form-urlencoded; charset=UTF-8",
    "url": AJS.contextPath() + "/rest/hcms_cme/1.0/condition/save",
    "data": 'pageId=' + AJS.params.pageId + '&' +
      AJS.$('#form-page').serialize(),
    "dataType": "json",
    "headers":{"X-Atlassian-Token": "no-check"},
    "beforeSend": function() { 
      hcms_cme.cond.dialog.disable(); 
    }, 
    "success": function(json, result) {
      if(result === 'success') {
        /* do nothing */ 
      } 
    }, 
    "complete": function() {
      hcms_cme.cond.dialog.enable();
    }
  });
}   
   
hcms_cme.cond.cancel = function() {  
} 
 
/* keymap related functions copied and adapted accordingly */ 
hcms_cme.toc = {};
     
hcms_cme.toc.clean = function() {  
  AJS.$('#cond-head-level option').each(function() {  
    //AJS.$(this).remove();
  }); 
  AJS.$('#cond-head-level').val('Heading 3');
}        

hcms_cme.toc.fetch = function() {
  jQuery.ajax({
    "type": "GET", 
    "url": AJS.contextPath() + "/rest/hcms_cme/1.0/toc/fetch",
    "dataType": "json", 
    "async": false,    
    "beforeSend": function() { 
      hcms_cme.toc.clean();  
    },  
    "success": function(data, result) { 
      if(result === 'success') {  
        hcms_cme.toc.fill(data['toc']); 
      } 
    }, 
   "complete": function() {
    }
  }); 
}    
    
hcms_cme.toc.fill = function(toc) { 
  AJS.$('#cond-head-level').val(toc[0].content);
} 
