/*
 * Decompiled with CFR 0.152.
 */
package com.hivestone.confluence.plugins.hcms.rest;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.importexport.ImportExportManager;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.GateKeeper;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.core.task.MultiQueueTaskManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.upm.api.license.PluginLicenseManager;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;

@Path(value="/condition")
public class ConditionMapService {
    private static final Logger LOG = Logger.getLogger(ConditionMapService.class);
    private PageManager pageManager;
    private SpaceManager spaceManager;
    private ApplicationProperties applicationProperties;
    private MultiQueueTaskManager taskManager;
    private UserManager userManager;
    private PluginLicenseManager pluginLicenseManager;
    private BandanaManager bandanaManager;
    private AttachmentManager attachmentManager;
    private ImportExportManager importExportManager;
    private GateKeeper gateKeeper;

    @Autowired
    public ConditionMapService(@ComponentImport PageManager pageManager, @ComponentImport BandanaManager bandanaManager, @ComponentImport SpaceManager spaceManager, @ComponentImport ApplicationProperties applicationProperties, @ComponentImport MultiQueueTaskManager taskManager, @ComponentImport UserManager userManager, @ComponentImport PluginLicenseManager pluginLicenseManager) {
        this.pageManager = pageManager;
        this.bandanaManager = bandanaManager;
        this.spaceManager = spaceManager;
        this.applicationProperties = applicationProperties;
        this.taskManager = taskManager;
        this.userManager = userManager;
        this.pluginLicenseManager = pluginLicenseManager;
    }

    @GET
    @Path(value="/status")
    @Produces(value={"application/xml", "application/json"})
    public Response Status() {
        JSONObject obj = new JSONObject();
        return Response.ok((Object)obj.toString()).build();
    }

    @GET
    @Path(value="/fetch/{page-id}")
    @Produces(value={"application/xml", "application/json"})
    public Response fetch(@PathParam(value="page-id") String pageId) {
        LOG.debug((Object)("Got the request. Fetching condition for page: " + pageId));
        JSONObject obj = new JSONObject();
        JSONObject objvar = new JSONObject();
        String space_map = "";
        try {
            String variable;
            Space space = this.pageManager.getPage((long)Integer.parseInt(pageId)).getSpace();
            ConfluenceBandanaContext cfc = new ConfluenceBandanaContext(space);
            String spaceMap = (String)this.bandanaManager.getValue((BandanaContext)cfc, "hivestone-cond-spacemap");
            if (spaceMap != null) {
                obj.put("hivestone-cond-spacemap", (Object)spaceMap);
            }
            if ((variable = (String)this.bandanaManager.getValue((BandanaContext)cfc, "hivestone-cond-variable")) != null) {
                objvar.put("hivestone-cond-variable", (Object)variable);
            }
            JSONArray array = new JSONArray();
            array.put((Object)obj);
            array.put((Object)objvar);
            space_map = array.toString();
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        LOG.debug((Object)"Sending response to caller.");
        return Response.ok((Object)space_map).build();
    }

    @POST
    @Path(value="/save")
    @Produces(value={"application/xml", "application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response save(@FormParam(value="pageId") String pageId, @FormParam(value="spacemap") String spaceMap, @FormParam(value="variable") String variable) {
        LOG.debug((Object)"Got the Condition data. Saving to DB");
        Space space = this.pageManager.getPage((long)Integer.parseInt(pageId)).getSpace();
        ConfluenceBandanaContext cfc = new ConfluenceBandanaContext(space);
        if (spaceMap != null) {
            this.bandanaManager.setValue((BandanaContext)cfc, "hivestone-cond-spacemap", (Object)spaceMap);
        }
        if (variable != null) {
            this.bandanaManager.setValue((BandanaContext)cfc, "hivestone-cond-variable", (Object)variable);
        }
        StringWriter dsw = new StringWriter();
        PrintWriter dpw = new PrintWriter((Writer)dsw, true);
        StringWriter tsw = new StringWriter();
        PrintWriter tpw = new PrintWriter((Writer)tsw, true);
        Date d = new Date();
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        dpw.printf("%d-%d-%d", c.get(1), 1 + c.get(2), c.get(5));
        tpw.printf("%d", d.getTime());
        this.bandanaManager.setValue((BandanaContext)cfc, "cond-modified-date", (Object)dsw.toString());
        this.bandanaManager.setValue((BandanaContext)cfc, "cond-modified-time", (Object)tsw.toString());
        LOG.debug((Object)"Sending response to caller.");
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    public void setBandanaManager(BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
        LOG.debug((Object)("BandanaManager: " + this.bandanaManager));
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
        LOG.debug((Object)("PageManager: " + this.pageManager));
    }

    public void setAttachmentManager(AttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
        LOG.debug((Object)("AttachmentManager: " + this.attachmentManager));
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
        LOG.debug((Object)("SpaceManager: " + this.spaceManager));
    }

    public void setImportExportManager(ImportExportManager importExportManager) {
        this.importExportManager = importExportManager;
        LOG.debug((Object)("ImportExportManager: " + this.importExportManager));
    }

    public void setApplicationProperties(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
        LOG.debug((Object)("ApplicationProperties: " + this.applicationProperties));
    }

    public void setGateKeeper(GateKeeper gateKeeper) {
        this.gateKeeper = gateKeeper;
        LOG.debug((Object)("GateKeeper: " + this.gateKeeper));
    }

    public void setMultiQueueTaskManager(MultiQueueTaskManager taskManager) {
        this.taskManager = taskManager;
        LOG.debug((Object)("TaskManager: " + this.taskManager));
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
        LOG.debug((Object)("UserManager: " + this.userManager));
    }
}

