/*
 * Decompiled with CFR 0.152.
 */
package com.hivestone.confluence.plugins.hcms.macro;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.Renderer;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPropertyManager;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUserImpl;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.confluence.xhtml.api.MacroDefinitionHandler;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.user.User;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;

public class ConditionalMultiExcerptIncludeMacro
extends BaseMacro
implements Macro {
    private static Logger LOG = Logger.getLogger(ConditionalMultiExcerptIncludeMacro.class);
    private final PageManager pageManager;
    private final SpaceManager spaceManager;
    private ContentPropertyManager contentPropertyManager;
    private Renderer renderer;
    private final BandanaManager bandanaManager;
    private final PluginLicenseManager pluginLicenseManager;
    private final XhtmlContent xhtmlUtils;
    private final UserManager userManager;
    private final NotificationManager notificationManager;

    public ConditionalMultiExcerptIncludeMacro(PageManager pageManager, SpaceManager spaceManager, ContentPropertyManager contentPropertyManager, XhtmlContent xhtmlUtils, BandanaManager bandanaManager, PluginLicenseManager pluginLicenseManager, Renderer renderee, UserManager userManager, NotificationManager notificationManager) {
        this.pageManager = pageManager;
        this.spaceManager = spaceManager;
        this.contentPropertyManager = contentPropertyManager;
        this.bandanaManager = bandanaManager;
        this.renderer = this.renderer;
        this.pluginLicenseManager = pluginLicenseManager;
        this.xhtmlUtils = xhtmlUtils;
        this.userManager = userManager;
        this.notificationManager = notificationManager;
    }

    public boolean isInline() {
        return true;
    }

    public boolean hasBody() {
        return false;
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.ALL;
    }

    public void setContentPropertyManager(ContentPropertyManager contentPropertyManager) {
        this.contentPropertyManager = contentPropertyManager;
    }

    public String execute(Map params, String body, RenderContext renderContext) throws MacroException {
        String conditionName;
        String result = "";
        PageContext conContext = (PageContext)renderContext;
        String spaceKey = conContext.getSpaceKey();
        if (this.pluginLicenseManager.getLicense().isDefined()) {
            PluginLicense license = (PluginLicense)this.pluginLicenseManager.getLicense().get();
            if (license.getError().isDefined()) {
                String err = "You does not have valid license for 'Conditional MultiExcerpt' plugin. Please purchase or renew your license.<br />";
                err = err + "Error:" + ((LicenseError)license.getError().get()).toString();
                return err;
            }
        } else {
            String err = "You does not have valid license for 'Conditional MultiExcerpt' plugin. Please purchase or renew your license.<br />";
            return err;
        }
        ConfluenceBandanaContext cfc = new ConfluenceBandanaContext(spaceKey);
        String manualDir = spaceKey;
        String spaceMap = (String)this.bandanaManager.getValue((BandanaContext)cfc, "hivestone-cond-spacemap");
        String source = (String)params.get("source");
        if (source == null || source.equals("")) {
            return "";
        }
        if (!source.contains(":")) {
            source = spaceKey + ":" + source;
        }
        if ((conditionName = (String)params.get("conname")) == null) {
            return "";
        }
        conditionName = conditionName.replaceAll("\\s*", "");
        String sourceSpaceKey = source.substring(0, source.indexOf(":"));
        String sourcePageTitle = source.substring(source.indexOf(":") + 1, source.length());
        String attachment_storage = "<ri:page ri:space-key=\"" + sourceSpaceKey + "\" ri:content-title=\"" + sourcePageTitle + "\" /></ri:attachment>";
        Page page = this.pageManager.getPage(sourceSpaceKey, sourcePageTitle);
        String mBody = this.contentPropertyManager.getTextProperty((ContentEntityObject)page, "hivestone.cme" + conditionName);
        if (mBody == null) {
            mBody = "";
        }
        PageContext c_con = new PageContext((ContentEntityObject)page, conContext);
        result = mBody;
        if (page != null) {
            try {
                String manualdir = "";
                if (manualDir != null && !manualDir.isEmpty()) {
                    manualdir = manualDir;
                }
                String toHide = "KEY_(((?!_END).)+)_END";
                String toShow_s = "KEY_" + manualdir + "_ST";
                String toShow_e = "KEY_" + manualdir + "_END";
                StringWriter tBody = new StringWriter();
                String spacemap = "";
                if (spacemap != null) {
                    spacemap = spaceMap;
                }
                String[] mappart = spacemap.split(";");
                result = result.replaceAll(toShow_s, "");
                result = result.replaceAll(toShow_e, "");
                for (int i = 0; i <= mappart.length - 1; ++i) {
                    if (!mappart[i].contains(manualdir + ":")) continue;
                    toShow_s = mappart[i];
                    toShow_s = toShow_s.replaceAll(manualdir + ":", "");
                    toShow_e = "KEY_" + toShow_s + "_END";
                    toShow_s = "KEY_" + toShow_s + "_ST ";
                    result = result.replaceAll(toShow_s, "");
                    result = result.replaceAll(toShow_e, "");
                }
                String string = result = result.replaceAll(toHide, "");
            }
            catch (Exception e) {
                LOG.error((Object)("ConditionalMultiExcerptIncludeMacro xhtmlException:" + e.getMessage()));
            }
        }
        if (result.matches(".*?<tr>\\s*<td (?!>).*>\\s*(<code>\\s*</code>)?\\s*(<em>\\s*</em>)?\\s*</td>\\s*<td(?!>).*>\\s*(<code>\\s*</code>)?\\s*(<em>\\s*</em>)?\\s*</td>\\s*</tr>.*")) {
            LOG.debug((Object)"Empty table row found.");
            result = result.replaceAll("<tr><td (((?!>).)+)>\\s*(<code>\\s*</code>)?\\s*(<em>\\s*</em>)?\\s*</td><td (((?!>).)+)>\\s*(<code>\\s*</code>)?\\s*(<em>\\s*</em>)?\\s*</td></tr>", "");
        }
        if ((result = result.replaceAll("<a href=(((?!>).)+)></a>", "")) == null || result.isEmpty()) {
            result = "";
        }
        return result.toString();
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    public String execute(Map<String, String> params, String body, ConversionContext conversionContext) throws MacroExecutionException {
        String conditionName;
        final String[] result = new String[1];
        String spaceKey = conversionContext.getSpaceKey();
        ConversionContext conContext = conversionContext;
        String ss_whereused_key = "";
        if (this.pluginLicenseManager.getLicense().isDefined()) {
            PluginLicense license = (PluginLicense)this.pluginLicenseManager.getLicense().get();
            if (license.getError().isDefined()) {
                String err = "You does not have valid license for 'Conditional MultiExcerpt' plugin. Please purchase or renew your license.<br />";
                err = err + "Error:" + ((LicenseError)license.getError().get()).toString();
                return err;
            }
        } else {
            String err = "You does not have valid license for 'Conditional MultiExcerpt' plugin. Please purchase or renew your license.<br />";
            return err;
        }
        ConfluenceBandanaContext cfc = new ConfluenceBandanaContext(spaceKey);
        final String manualDir = spaceKey;
        String spaceMap = (String)this.bandanaManager.getValue((BandanaContext)cfc, "hivestone-cond-spacemap");
        String variables = (String)this.bandanaManager.getValue((BandanaContext)cfc, "hivestone-cond-variable");
        String source = params.get("source");
        if (source == null || source.equals("")) {
            return "";
        }
        if (!source.contains(":")) {
            source = spaceKey + ":" + source;
        }
        if ((conditionName = params.get("conname")) == null) {
            return "";
        }
        String sourceSpaceKey = source.substring(0, source.indexOf(":"));
        String sourcePageTitle = source.substring(source.indexOf(":") + 1, source.length());
        ConfluenceBandanaContext scfc = new ConfluenceBandanaContext(sourceSpaceKey);
        String sVariables = (String)this.bandanaManager.getValue((BandanaContext)scfc, "hivestone-cond-variable");
        String attachment_storage = "<ri:page ri:space-key=\"" + sourceSpaceKey + "\" ri:content-title=\"" + sourcePageTitle + "\" /></ri:attachment>";
        Page page = this.pageManager.getPage(sourceSpaceKey, sourcePageTitle);
        DefaultConversionContext c_con = new DefaultConversionContext((RenderContext)page.toPageContext());
        if (page != null) {
            String pageBody = page.getBodyAsString();
            ss_whereused_key = conditionName + "@@" + sourceSpaceKey + ":" + page.getTitle();
            String whereused_val = (String)this.bandanaManager.getValue((BandanaContext)scfc, ss_whereused_key);
            String destination_entry = spaceKey + ":" + conversionContext.getEntity().getDisplayTitle();
            if (whereused_val == null || whereused_val != null && !whereused_val.contains("@@" + destination_entry)) {
                String user = this.userManager.getRemoteUsername();
                destination_entry = user + "@@" + destination_entry;
                whereused_val = whereused_val == null ? destination_entry : whereused_val + "__SEP__" + destination_entry;
                this.bandanaManager.setValue((BandanaContext)scfc, ss_whereused_key, (Object)whereused_val);
                this.notificationManager.addContentNotification((User)((ConfluenceUserImpl)this.userManager.resolve(this.userManager.getRemoteUsername())), (ContentEntityObject)page);
            }
            try {
                this.xhtmlUtils.handleMacroDefinitions(pageBody, conversionContext, new MacroDefinitionHandler((ConversionContext)c_con, spaceMap, variables, sVariables){
                    final /* synthetic */ ConversionContext val$c_con;
                    final /* synthetic */ String val$spaceMap;
                    final /* synthetic */ String val$variables;
                    final /* synthetic */ String val$sVariables;
                    {
                        this.val$c_con = conversionContext;
                        this.val$spaceMap = string3;
                        this.val$variables = string4;
                        this.val$sVariables = string5;
                    }

                    public void handle(MacroDefinition md) {
                        Map conditionParams;
                        if (md.getName().equals("conditionalmultiexcerptmacro") && ((String)(conditionParams = md.getParameters()).get("conname")).equals(conditionName)) {
                            String value;
                            String var;
                            String[] var_value;
                            int i;
                            String manualdir = "";
                            if (manualDir != null && !manualDir.isEmpty()) {
                                manualdir = manualDir;
                            }
                            String toHide = "KEY_(((?!_END).)+)_END";
                            String toShow_s = "KEY_" + manualdir + "_ST";
                            String toShow_e = "KEY_" + manualdir + "_END";
                            String scolor = (String)conditionParams.get("color");
                            String mBody = md.getStorageBodyText();
                            try {
                                result[0] = ConditionalMultiExcerptIncludeMacro.this.xhtmlUtils.convertStorageToView(mBody, this.val$c_con);
                            }
                            catch (XMLStreamException e) {
                                result[0] = mBody;
                                LOG.error((Object)("ConditionalMultiExcerptIncludeMacro xhtmlStreamException:" + e.getMessage()));
                            }
                            catch (XhtmlException e) {
                                result[0] = mBody;
                                LOG.error((Object)("ConditionalMultiExcerptIncludeMacro xhtmlStreamException:" + e.getMessage()));
                            }
                            StringWriter tBody = new StringWriter();
                            if (scolor == null) {
                                scolor = "";
                            }
                            scolor = scolor.equals("Green") ? "<span class=\"hivestonegreenfont\">" : (scolor.equals("Red") ? "<span class=\"hivestoneredfont\">" : (scolor.equals("Blue") ? "<span class=\"hivestonebluefont\">" : ""));
                            scolor = "";
                            String spacemap = "";
                            if (this.val$spaceMap != null) {
                                spacemap = this.val$spaceMap;
                            }
                            String[] mappart = spacemap.split(";");
                            result[0] = result[0].replaceAll(toShow_s, scolor);
                            result[0] = scolor.isEmpty() ? result[0].replaceAll(toShow_e, "") : result[0].replaceAll(toShow_e, "</span>");
                            for (int i2 = 0; i2 <= mappart.length - 1; ++i2) {
                                if (!mappart[i2].contains(manualdir + ":")) continue;
                                toShow_s = mappart[i2];
                                toShow_s = toShow_s.replaceAll(manualdir + ":", "");
                                toShow_e = "KEY_" + toShow_s + "_END";
                                toShow_s = "KEY_" + toShow_s + "_ST";
                                result[0] = result[0].replaceAll(toShow_s, scolor);
                                result[0] = scolor.isEmpty() ? result[0].replaceAll(toShow_e, "") : result[0].replaceAll(toShow_e, "</span>");
                            }
                            result[0] = result[0].replaceAll(toHide, "");
                            String varMap = "";
                            String sVarMap = "";
                            if (this.val$variables != null) {
                                varMap = this.val$variables;
                            }
                            if (this.val$sVariables != null) {
                                sVarMap = this.val$sVariables;
                            }
                            String[] var_values = varMap.split("\\n");
                            String[] svar_values = sVarMap.split("\\n");
                            String[] vars = new String[var_values.length + svar_values.length];
                            int vars_index = 0;
                            HashMap<String, String> map = new HashMap<String, String>();
                            for (i = 0; i <= var_values.length - 1; ++i) {
                                if (var_values[i] == null || var_values[i].isEmpty() || !var_values[i].contains(":")) continue;
                                var_value = var_values[i].split(":");
                                var = var_value[0].trim();
                                var = var.replace("$", "\\Q$");
                                value = var_value[1].trim();
                                vars[vars_index] = var;
                                map.put(var, value);
                                ++vars_index;
                            }
                            for (i = 0; i <= svar_values.length - 1; ++i) {
                                if (svar_values[i] == null || svar_values[i].isEmpty() || !svar_values[i].contains(":")) continue;
                                var_value = svar_values[i].split(":");
                                var = var_value[0].trim();
                                var = var.replace("$", "\\Q$");
                                value = var_value[1].trim();
                                vars[vars_index] = var;
                                if (!map.containsKey(var)) {
                                    map.put(var, value);
                                }
                                ++vars_index;
                            }
                            Arrays.sort(vars, new Comparator<String>(){

                                @Override
                                public int compare(String s1, String s2) {
                                    if (s1 != null && !s1.isEmpty() && s2 != null && !s2.isEmpty()) {
                                        return s2.length() - s1.length();
                                    }
                                    return 0;
                                }
                            });
                            for (i = 0; i <= vars_index - 1; ++i) {
                                if (vars[i] == null || vars[i].isEmpty() || !map.containsKey(vars[i])) continue;
                                result[0] = result[0].replaceAll(vars[i], (String)map.get(vars[i]));
                            }
                            String ht_out = "";
                            if (!ht_out.isEmpty() && !ht_out.contains("com.ctc.wstx.exc.WstxLazyException")) {
                                result[0] = ht_out;
                            }
                        }
                    }
                });
            }
            catch (XhtmlException e) {
                LOG.error((Object)("ConditionalMultiExcerptIncludeMacro xhtmlException:" + e.getMessage()));
            }
        }
        if (result[0].matches(".*?<tr>\\s*<td (?!>).*>\\s*(<code>\\s*</code>)?\\s*(<em>\\s*</em>)?\\s*</td>\\s*<td(?!>).*>\\s*(<code>\\s*</code>)?\\s*(<em>\\s*</em>)?\\s*</td>\\s*</tr>.*")) {
            LOG.debug((Object)"Empty table row found.");
            result[0] = result[0].replaceAll("<tr><td (((?!>).)+)>\\s*(<code>\\s*</code>)?\\s*(<em>\\s*</em>)?\\s*</td><td (((?!>).)+)>\\s*(<code>\\s*</code>)?\\s*(<em>\\s*</em>)?\\s*</td></tr>", "");
        }
        result[0] = result[0].replaceAll("<a href=(((?!>).)+)></a>", "");
        if (result[0] == null || result[0].isEmpty()) {
            result[0] = "";
        }
        return result[0].toString();
    }
}

