/*
 * Decompiled with CFR 0.152.
 */
package com.hivestone.confluence.plugins.hcms.common;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.confluence.xhtml.api.MacroDefinitionHandler;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.renderer.RenderContext;
import com.hivestone.confluence.plugins.hcms.common.CaptionType;
import com.hivestone.confluence.plugins.hcms.util.HivestoneBandanaContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaptionHandler
implements MacroDefinitionHandler {
    private static Logger LOG = LoggerFactory.getLogger(CaptionHandler.class);
    private static HivestoneBandanaContext hbc = new HivestoneBandanaContext();
    private static String figureCountKeyTemplate = "_FIGURE_COUNT[__PAGE_ID__]";
    private static String tableCountKeyTemplate = "_TABLE_COUNT[__PAGE_ID__]";
    private static String equationCountKeyTemplate = "_EQUATION_COUNT[__PAGE_ID__]";
    private static String exampleCountKeyTemplate = "_EXAMPLE_COUNT[__PAGE_ID__]";
    private static BandanaManager bandanaManager;
    private static XhtmlContent xhtmlContent;
    private Page page;
    private ConversionContext context;
    private static boolean counted_pages_above;
    private List<MacroDefinition> figures;
    private List<MacroDefinition> tables;
    private List<MacroDefinition> equations;
    private List<MacroDefinition> examples;
    private String figureCountKey = "";
    private String tableCountKey = "";
    private String equationCountKey = "";
    private String exampleCountKey = "";

    public CaptionHandler(Page page, BandanaManager bandanaManager, XhtmlContent xhtmlContent) {
        CaptionHandler.bandanaManager = bandanaManager;
        CaptionHandler.xhtmlContent = xhtmlContent;
        this.page = page;
        this.context = new DefaultConversionContext((RenderContext)page.toPageContext());
        this.figures = new ArrayList<MacroDefinition>();
        this.tables = new ArrayList<MacroDefinition>();
        this.equations = new ArrayList<MacroDefinition>();
        this.examples = new ArrayList<MacroDefinition>();
        this.figureCountKey = figureCountKeyTemplate.replaceAll("__PAGE_ID__", page.getIdAsString());
        this.tableCountKey = tableCountKeyTemplate.replaceAll("__PAGE_ID__", page.getIdAsString());
        this.equationCountKey = equationCountKeyTemplate.replaceAll("__PAGE_ID__", page.getIdAsString());
        this.exampleCountKey = exampleCountKeyTemplate.replaceAll("__PAGE_ID__", page.getIdAsString());
    }

    public void handle(MacroDefinition macroDefinition) {
        String macroName = macroDefinition.getName();
        Map params = macroDefinition.getParameters();
        if (macroName.equals("captionmacro")) {
            for (String key : params.keySet()) {
                if (!key.equals("captionOf")) continue;
                switch (CaptionType.valueOf((String)params.get(key))) {
                    case Figure: {
                        this.figures.add(macroDefinition);
                        break;
                    }
                    case Table: {
                        this.tables.add(macroDefinition);
                        break;
                    }
                    case Equation: {
                        this.equations.add(macroDefinition);
                        break;
                    }
                    case Example: {
                        this.examples.add(macroDefinition);
                    }
                }
            }
        }
    }

    public List<MacroDefinition> getFigures() {
        return this.figures;
    }

    public List<MacroDefinition> getTables() {
        return this.tables;
    }

    public List<MacroDefinition> getEquations() {
        return this.equations;
    }

    public List<MacroDefinition> getExamples() {
        return this.examples;
    }

    public int getFigureCount() {
        return this.figures.size();
    }

    public int getTableCount() {
        return this.tables.size();
    }

    public int getEquationCount() {
        return this.equations.size();
    }

    public int getExampleCount() {
        return this.examples.size();
    }

    public void loadPage() {
        try {
            xhtmlContent.handleMacroDefinitions(this.page.getBodyAsString(), this.context, (MacroDefinitionHandler)this);
        }
        catch (XhtmlException e) {
            LOG.error("PageObjectCounter::updatePageObjectCount", e);
        }
    }

    public void updateObjectCount() {
        this.loadPage();
        this.updateFigureCount();
        this.updateTableCount();
        this.updateEquationCount();
        this.updateExampleCount();
    }

    private void updateFigureCount() {
        bandanaManager.setValue((BandanaContext)hbc, this.figureCountKey, (Object)this.getFigureCount());
    }

    private void updateTableCount() {
        bandanaManager.setValue((BandanaContext)hbc, this.tableCountKey, (Object)this.getTableCount());
    }

    private void updateEquationCount() {
        bandanaManager.setValue((BandanaContext)hbc, this.equationCountKey, (Object)this.getEquationCount());
    }

    private void updateExampleCount() {
        bandanaManager.setValue((BandanaContext)hbc, this.exampleCountKey, (Object)this.getExampleCount());
    }

    public String getAutoNumber(String macroUid) {
        String autoNumber = "";
        CaptionType itemType = this.getItemType(macroUid);
        long chapterNumber = CaptionHandler.findChapterNumberForPage(this.page);
        autoNumber = chapterNumber >= 560L ? (char)(chapterNumber -= 500L) + ".x" : chapterNumber + ".x";
        long itemNumber = this.findItemNumber(macroUid, itemType);
        autoNumber = autoNumber.replaceAll("x", String.valueOf(itemNumber));
        return autoNumber;
    }

    public CaptionType getItemType(String macroUid) {
        CaptionType itemType = CaptionType.Undefined;
        boolean found = false;
        for (MacroDefinition md : this.figures) {
            if (!((String)md.getParameters().get("uniqueId")).equals(macroUid)) continue;
            itemType = CaptionType.valueOf((String)md.getParameters().get("captionOf"));
            found = true;
            break;
        }
        if (!found) {
            for (MacroDefinition md : this.tables) {
                if (!((String)md.getParameters().get("uniqueId")).equals(macroUid)) continue;
                itemType = CaptionType.valueOf((String)md.getParameters().get("captionOf"));
                found = true;
                break;
            }
        }
        if (!found) {
            for (MacroDefinition md : this.equations) {
                if (!((String)md.getParameters().get("uniqueId")).equals(macroUid)) continue;
                itemType = CaptionType.valueOf((String)md.getParameters().get("captionOf"));
                found = true;
                break;
            }
        }
        if (!found) {
            for (MacroDefinition md : this.examples) {
                if (!((String)md.getParameters().get("uniqueId")).equals(macroUid)) continue;
                itemType = CaptionType.valueOf((String)md.getParameters().get("captionOf"));
                found = true;
                break;
            }
        }
        return itemType;
    }

    public static long findChapterNumberForPage(Page page) {
        long chapterNumber = 0L;
        if (!page.isHomePage()) {
            String appendix_char;
            Page p = page;
            while (!p.getParent().isHomePage()) {
                p = p.getParent();
            }
            long location = 0L;
            for (Page chapter : page.getSpace().getHomePage().getSortedChildren()) {
                String chapterTitle = chapter.getTitle();
                if (!chapterTitle.equalsIgnoreCase("titlecopy") && !chapterTitle.equalsIgnoreCase("Preface")) {
                    ++location;
                }
                if (!p.equals((Object)chapter)) continue;
                chapterNumber = location;
                break;
            }
            if (p.getTitle().equalsIgnoreCase("titlecopy") || p.getTitle().equalsIgnoreCase("Preface")) {
                chapterNumber = 0L;
            }
            if (p.getTitle().startsWith("Appendix ") && (appendix_char = p.getTitle().substring(9, 14)).contains(":")) {
                appendix_char = appendix_char.substring(0, appendix_char.indexOf(":"));
                appendix_char = appendix_char.trim();
                chapterNumber = appendix_char.charAt(0);
                chapterNumber += 500L;
            }
        }
        return chapterNumber;
    }

    private long findItemNumber(String macroUid, CaptionType itemType) {
        long itemNumber = 0L;
        if (!this.page.isHomePage()) {
            Page p = this.page;
            while (!p.getParent().isHomePage()) {
                p = p.getParent();
            }
            counted_pages_above = false;
            itemNumber += CaptionHandler.countItems(p, this.page, itemType);
        }
        List<MacroDefinition> items = null;
        switch (itemType) {
            case Figure: {
                items = this.getFigures();
                break;
            }
            case Table: {
                items = this.getTables();
                break;
            }
            case Equation: {
                items = this.getEquations();
                break;
            }
            case Example: {
                items = this.getExamples();
            }
        }
        for (MacroDefinition item : items) {
            ++itemNumber;
            String itemUid = (String)item.getParameters().get("uniqueId");
            if (itemUid == null || !itemUid.equals(macroUid)) continue;
            break;
        }
        return itemNumber;
    }

    public static long countItems(Page from, Page to, CaptionType itemType) {
        long count = 0L;
        if (!from.equals((Object)to)) {
            String itemKey = "";
            switch (itemType) {
                case Figure: {
                    itemKey = figureCountKeyTemplate.replaceAll("__PAGE_ID__", from.getIdAsString());
                    break;
                }
                case Table: {
                    itemKey = tableCountKeyTemplate.replaceAll("__PAGE_ID__", from.getIdAsString());
                    break;
                }
                case Equation: {
                    itemKey = equationCountKeyTemplate.replaceAll("__PAGE_ID__", from.getIdAsString());
                    break;
                }
                case Example: {
                    itemKey = exampleCountKeyTemplate.replaceAll("__PAGE_ID__", from.getIdAsString());
                }
            }
            Integer countObject = (Integer)bandanaManager.getValue((BandanaContext)hbc, itemKey);
            if (countObject != null) {
                count += countObject.longValue();
            }
            for (Page child : from.getSortedChildren()) {
                count += CaptionHandler.countItems(child, to, itemType);
                if (!child.equals((Object)to) && !counted_pages_above) continue;
                counted_pages_above = true;
                break;
            }
        }
        return count;
    }
}

