/*
 * Decompiled with CFR 0.152.
 */
package com.hivestone.confluence.plugins.hcms.rest;

import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class AutoNumEntityResolver
implements EntityResolver {
    private static final Logger LOG = LoggerFactory.getLogger(AutoNumEntityResolver.class);

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws IOException {
        try {
            InputSource source = null;
            InputStream stream = null;
            if (publicId.equals("-//W3C//DTD XHTML 1.0 Strict//EN")) {
                stream = this.getClass().getResourceAsStream("/dtds/xhtml1/DTD/xhtml1-strict.dtd");
            } else if (publicId.equals("-//W3C//DTD XHTML 1.0 Transitional//EN")) {
                stream = this.getClass().getResourceAsStream("/dtds/xhtml1/DTD/xhtml1-transitional.dtd");
            } else if (publicId.equals("-//W3C//DTD XHTML 1.0 Frameset//EN")) {
                stream = this.getClass().getResourceAsStream("/dtds/xhtml1/DTD/xhtml1-frameset.dtd");
            } else if (publicId.equals("-//W3C//ENTITIES Latin 1 for XHTML//EN")) {
                stream = this.getClass().getResourceAsStream("/dtds/xhtml1/DTD/xhtml-lat1.ent");
            } else if (publicId.equals("-//W3C//ENTITIES Special for XHTML//EN")) {
                stream = this.getClass().getResourceAsStream("/dtds/xhtml1/DTD/xhtml-special.ent");
            } else if (publicId.equals("-//W3C//ENTITIES Symbols for XHTML//EN")) {
                stream = this.getClass().getResourceAsStream("/dtds/xhtml1/DTD/xhtml-symbol.ent");
            }
            if (stream != null) {
                source = new InputSource(stream);
            }
            return source;
        }
        catch (Exception e) {
            LOG.error("File Not found", e);
            return null;
        }
    }
}

