/*
 * Decompiled with CFR 0.152.
 */
package com.hivestone.confluence.plugins.hcms.util;

import com.hivestone.confluence.plugins.hcms.util.AlphabeticalFormat;
import com.hivestone.confluence.plugins.hcms.util.DecimalFormat;
import com.hivestone.confluence.plugins.hcms.util.NumberFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;

public class AutoNumberedHeadingConfiguration {
    private int numbering_level;
    private int[] starting_number = new int[6];
    private String number_format;
    private String excluded_pages;
    private NumberFormat decimal_alphabetic;
    private int page_level = 0;
    boolean number_page_titles = false;

    public AutoNumberedHeadingConfiguration() {
    }

    public AutoNumberedHeadingConfiguration(Map<String, String> params) {
        this.number_format = params.get("num-format");
        if (this.number_format == null) {
            this.number_format = "Decimal";
        }
        this.decimal_alphabetic = this.number_format.contains("Alpha") ? new AlphabeticalFormat() : new DecimalFormat();
        this.setStartingNumber(params.get("starting-number"));
        String num_level = params.get("num-level");
        this.excluded_pages = params.get("excluded-pages");
        if (this.excluded_pages == null) {
            this.excluded_pages = "";
        }
        if (num_level == null) {
            this.numbering_level = 4;
        } else {
            try {
                this.numbering_level = Integer.valueOf(num_level);
            }
            catch (NumberFormatException e) {
                this.numbering_level = 4;
            }
        }
        String p_level = params.get("hv-page-level");
        if (p_level != null) {
            this.page_level = Integer.valueOf(p_level);
        }
    }

    private void setStartingNumber(String start_with) {
        for (int i = 0; i < 6; ++i) {
            this.starting_number[i] = 0;
        }
        if (start_with != null && !start_with.trim().isEmpty()) {
            start_with = start_with.trim();
            String[] parts = start_with.split("\\.");
            for (int i = 0; i < parts.length; ++i) {
                char character;
                if (this.isInteger(parts[i])) {
                    try {
                        this.starting_number[i] = Integer.valueOf(parts[i]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (!Character.isLetter(parts[i].charAt(0))) continue;
                char ascii = character = parts[i].substring(0, 1).toUpperCase(Locale.ENGLISH).charAt(0);
                this.starting_number[i] = ascii - 64;
                if (parts[i].length() <= 1 || !Character.isLetter(parts[i].charAt(1))) continue;
                ascii = character = parts[i].substring(1, 2).toUpperCase(Locale.ENGLISH).charAt(0);
                int n = i;
                this.starting_number[n] = this.starting_number[n] + (ascii - 64);
            }
        }
    }

    public boolean isInteger(String str) {
        if (str.isEmpty()) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (!(i == 0 && str.charAt(i) == '-' ? str.length() == 1 : Character.digit(str.charAt(i), 10) < 0)) continue;
            return false;
        }
        return true;
    }

    public void setNumberingLevel(int maxLevel) {
        this.numbering_level = maxLevel;
    }

    public int getNumberingLevel() {
        return this.numbering_level;
    }

    public int[] getStartingNumber() {
        return Arrays.copyOf(this.starting_number, this.starting_number.length);
    }

    public void setNumberingFormat(NumberFormat format) {
        this.decimal_alphabetic = format;
    }

    public NumberFormat getNumberingFormat() {
        return this.decimal_alphabetic;
    }

    public void setExcludedPages(String page_titles) {
        this.excluded_pages = page_titles;
    }

    public String getExcludedPages() {
        return this.excluded_pages;
    }

    public void setCurrentPageLevel(int pageLevel) {
        this.page_level = pageLevel;
    }

    public int getCurrentPageLevel() {
        return this.page_level;
    }

    public void setNumberPageTitles(boolean number) {
        this.number_page_titles = number;
    }

    public boolean getNumberPageTitles() {
        return this.number_page_titles;
    }
}

