/*
 * Decompiled with CFR 0.152.
 */
package com.hivestone.confluence.plugins.hcms.macro;

import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugins.osgi.javaconfig.OsgiServices;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.hivestone.confluence.plugins.hcms.util.AutoNumberedHeadingConfiguration;
import com.hivestone.confluence.plugins.hcms.util.HeadingNumberAllocator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HivestoneAutoNumberedHeadingMacro
extends BaseMacro
implements Macro {
    private static Logger LOG = LoggerFactory.getLogger(HivestoneAutoNumberedHeadingMacro.class);
    private final PageManager pageManager = OsgiServices.importOsgiService(PageManager.class);
    private final SpaceManager spaceManager;
    private final BandanaManager bandanaManager = OsgiServices.importOsgiService(BandanaManager.class);
    private final PluginLicenseManager pluginLicenseManager;

    public HivestoneAutoNumberedHeadingMacro() {
        this.spaceManager = OsgiServices.importOsgiService(SpaceManager.class);
        this.pluginLicenseManager = OsgiServices.importOsgiService(PluginLicenseManager.class);
    }

    public boolean isInline() {
        return false;
    }

    public boolean hasBody() {
        return false;
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.ALL;
    }

    public String execute(Map params, String body, RenderContext renderContext) throws MacroException {
        StringBuffer result = new StringBuffer();
        result.append("");
        return result.toString();
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.RICH_TEXT;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    public final boolean suppressSurroundingTagDuringWysiwygRendering() {
        return false;
    }

    public final boolean suppressMacroRenderingDuringWysiwyg() {
        return true;
    }

    public String execute(Map<String, String> params, String body, ConversionContext conversionContext) throws MacroExecutionException {
        String result = "";
        if (conversionContext.getPageContext() != conversionContext.getPageContext().getOriginalContext()) {
            return body;
        }
        String autonum_enable = params.get("hv-autonum-enable");
        if (autonum_enable == null) {
            autonum_enable = "true";
        }
        if (this.pluginLicenseManager.getLicense().isDefined()) {
            PluginLicense license = (PluginLicense)this.pluginLicenseManager.getLicense().get();
            if (license.getError().isDefined()) {
                String err = "<font style='color:red;'>You does not have valid license for 'Auto Numbered Headings' plugin. Please purchase or renew your license.</font><br/>";
                err = err + "Error:" + ((LicenseError)license.getError().get()).toString() + "<br/>" + body;
                return body;
            }
        } else {
            String err = "<font style='color:red'>You does not have valid license for 'Auto Numbered Headings' plugin. Please purchase or renew your license.</font><br/>" + body;
            return body;
        }
        if (!autonum_enable.equalsIgnoreCase("true")) {
            return body;
        }
        try {
            AutoNumberedHeadingConfiguration config = new AutoNumberedHeadingConfiguration(params);
            HeadingNumberAllocator allocator = new HeadingNumberAllocator(config);
            result = allocator.allocateNumbers(body);
        }
        catch (Exception e) {
            System.out.println("Macro throws an exception:" + e.getMessage());
        }
        return result;
    }
}

