/*
 * Decompiled with CFR 0.152.
 */
package com.hivestone.confluence.plugins.hcms.rest;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.importexport.ImportExportManager;
import com.atlassian.confluence.mail.template.ConfluenceMailQueueItem;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.GateKeeper;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.core.task.MultiQueueTaskManager;
import com.atlassian.core.task.Task;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.renderer.RenderContext;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.hivestone.confluence.plugins.hcms.rest.AutoNumEntityResolver;
import com.hivestone.confluence.plugins.hcms.rest.UniqueId;
import com.hivestone.confluence.plugins.hcms.util.AlphabeticalFormat;
import com.hivestone.confluence.plugins.hcms.util.DecimalFormat;
import com.hivestone.confluence.plugins.hcms.util.NumberFormat;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Path(value="/book")
public class AutoNumHeadService {
    private static final Logger LOG = Logger.getLogger(AutoNumHeadService.class);
    private PageManager pageManager;
    private SpaceManager spaceManager;
    private ApplicationProperties applicationProperties;
    private MultiQueueTaskManager taskManager;
    private UserManager userManager;
    private PluginLicenseManager pluginLicenseManager;
    private BandanaManager bandanaManager;
    private XhtmlContent xhtmlUtils;
    private AttachmentManager attachmentManager;
    private ImportExportManager importExportManager;
    private GateKeeper gateKeeper;

    @Autowired
    public AutoNumHeadService(@ComponentImport PageManager pageManager, @ComponentImport BandanaManager bandanaManager, @ComponentImport SpaceManager spaceManager, @ComponentImport ApplicationProperties applicationProperties, @ComponentImport MultiQueueTaskManager taskManager, @ComponentImport UserManager userManager, @ComponentImport PluginLicenseManager pluginLicenseManager, @ComponentImport XhtmlContent xhtmlUtils) {
        this.pageManager = pageManager;
        this.bandanaManager = bandanaManager;
        this.spaceManager = spaceManager;
        this.applicationProperties = applicationProperties;
        this.taskManager = taskManager;
        this.userManager = userManager;
        this.pluginLicenseManager = pluginLicenseManager;
        this.xhtmlUtils = xhtmlUtils;
    }

    @GET
    @Path(value="/fetch/config/{spacekey}")
    @Produces(value={"application/xml", "application/json"})
    public Response FetchRequest(@PathParam(value="spacekey") String spaceKey) {
        String removeNum;
        String excludePages;
        String numOnlyTitles;
        String numTitles;
        String numLevel;
        PluginLicense license;
        LOG.debug((Object)("Got the fetch config request for space - " + spaceKey));
        String lic = "false";
        lic = this.pluginLicenseManager.getLicense().isDefined() ? ((license = (PluginLicense)this.pluginLicenseManager.getLicense().get()).getError().isDefined() ? "false" : "true") : "false";
        Space space = this.spaceManager.getSpace(spaceKey);
        ConfluenceBandanaContext cfc = new ConfluenceBandanaContext(space);
        String numFormat = (String)this.bandanaManager.getValue((BandanaContext)cfc, "hivestone-auto-num-head-num-format");
        if (numFormat == null) {
            numFormat = "Default";
        }
        if ((numLevel = (String)this.bandanaManager.getValue((BandanaContext)cfc, "hivestone-auto-num-head-num-level")) == null) {
            numLevel = "4";
        }
        if ((numTitles = (String)this.bandanaManager.getValue((BandanaContext)cfc, "hivestone-auto-num-head-num-titles")) == null) {
            numTitles = "false";
        }
        if ((numOnlyTitles = (String)this.bandanaManager.getValue((BandanaContext)cfc, "hivestone-auto-num-head-num-onlytitles")) == null) {
            numOnlyTitles = "false";
        }
        if ((excludePages = (String)this.bandanaManager.getValue((BandanaContext)cfc, "hivestone-auto-num-head-exclude-pages")) == null) {
            excludePages = "";
        }
        if ((removeNum = (String)this.bandanaManager.getValue((BandanaContext)cfc, "hivestone-remove-auto-numhead")) == null) {
            removeNum = "false";
        }
        JSONObject configObject = new JSONObject();
        try {
            configObject.put("num-format", (Object)numFormat);
            configObject.put("num-level", (Object)numLevel);
            configObject.put("num-titles", (Object)numTitles);
            configObject.put("num-onlytitles", (Object)numOnlyTitles);
            configObject.put("exclude-pages", (Object)excludePages);
            configObject.put("remove-auto-numhead", (Object)removeNum);
            configObject.put("license", (Object)lic);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return Response.ok((Object)configObject.toString()).build();
    }

    @POST
    @Path(value="/config/save")
    @Produces(value={"application/xml", "application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response save(@FormParam(value="pageId") String pageId, @FormParam(value="num-format") String numFormat, @FormParam(value="num-level") String numLevel, @FormParam(value="num-titles") String numTitles, @FormParam(value="num-onlytitles") String numOnlyTitles, @FormParam(value="exclude-pages") String excludePages, @FormParam(value="remove-auto-numhead") String removeNum) {
        LOG.debug((Object)"Got the Config data. Saving to DB");
        String username = this.userManager.getRemoteUsername();
        UserProfile user = this.userManager.getUserProfile(username);
        if (this.pluginLicenseManager.getLicense().isDefined()) {
            PluginLicense license = (PluginLicense)this.pluginLicenseManager.getLicense().get();
            if (license.getError().isDefined()) {
                String err = "<br/><br/><font style='color:red;'>You do not have valid license for 'Auto Numbered Headings' plugin. Please purchase or renew your license.</font><br/>";
                err = err + "Error:" + ((LicenseError)license.getError().get()).toString() + "<br/>";
                this.licenseError(err, user, "");
                return Response.status((Response.Status)Response.Status.OK).build();
            }
        } else {
            String err = "<br/><br/><font style='color:red'>You do not have valid license for 'Auto Numbered Headings' plugin. Please purchase or renew your license.</font><br/>";
            this.licenseError(err, user, "");
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        Space space = this.pageManager.getPage((long)Integer.parseInt(pageId)).getSpace();
        ConfluenceBandanaContext cfc = new ConfluenceBandanaContext(space);
        if (numFormat != null) {
            this.bandanaManager.setValue((BandanaContext)cfc, "hivestone-auto-num-head-num-format", (Object)numFormat);
        }
        if (numLevel != null) {
            this.bandanaManager.setValue((BandanaContext)cfc, "hivestone-auto-num-head-num-level", (Object)numLevel);
        }
        if (numTitles != null) {
            this.bandanaManager.setValue((BandanaContext)cfc, "hivestone-auto-num-head-num-titles", (Object)"true");
        } else {
            this.bandanaManager.setValue((BandanaContext)cfc, "hivestone-auto-num-head-num-titles", (Object)"false");
        }
        if (numOnlyTitles != null) {
            this.bandanaManager.setValue((BandanaContext)cfc, "hivestone-auto-num-head-num-onlytitles", (Object)"true");
        } else {
            this.bandanaManager.setValue((BandanaContext)cfc, "hivestone-auto-num-head-num-onlytitles", (Object)"false");
        }
        if (excludePages != null) {
            this.bandanaManager.setValue((BandanaContext)cfc, "hivestone-auto-num-head-exclude-pages", (Object)excludePages);
        }
        if (removeNum != null) {
            this.bandanaManager.setValue((BandanaContext)cfc, "hivestone-remove-auto-numhead", (Object)"true");
        } else {
            this.bandanaManager.setValue((BandanaContext)cfc, "hivestone-remove-auto-numhead", (Object)"false");
        }
        StringWriter dsw = new StringWriter();
        PrintWriter dpw = new PrintWriter((Writer)dsw, true);
        StringWriter tsw = new StringWriter();
        PrintWriter tpw = new PrintWriter((Writer)tsw, true);
        Date d = new Date();
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        dpw.printf("%d-%d-%d", c.get(1), 1 + c.get(2), c.get(5));
        tpw.printf("%d", d.getTime());
        this.bandanaManager.setValue((BandanaContext)cfc, "hivestone-auto-num-head-modified-date", (Object)dsw.toString());
        this.bandanaManager.setValue((BandanaContext)cfc, "hivestone-auto-num-head-modified-time", (Object)tsw.toString());
        LOG.debug((Object)"Sending response to caller.");
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @POST
    @Path(value="/autonumhead/update")
    @Produces(value={"application/xml", "application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response update(@FormParam(value="pageId") String pageId, @FormParam(value="num-format") String numFormat, @FormParam(value="num-level") String numLevel, @FormParam(value="num-titles") String numTitles, @FormParam(value="num-onlytitles") String numOnlyTitles, @FormParam(value="exclude-pages") String excludePages, @FormParam(value="remove-auto-numhead") String removeNum) {
        LOG.debug((Object)"Got the Config data. Updating space.");
        String username = this.userManager.getRemoteUsername();
        UserProfile user = this.userManager.getUserProfile(username);
        if (this.pluginLicenseManager.getLicense().isDefined()) {
            PluginLicense license = (PluginLicense)this.pluginLicenseManager.getLicense().get();
            if (license.getError().isDefined()) {
                String err = "<br/><br/><font style='color:red;'>You do not have valid license for 'Auto Numbered Headings' plugin. Please purchase or renew your license.</font><br/>";
                err = err + "Error:" + ((LicenseError)license.getError().get()).toString() + "<br/>";
                this.licenseError(err, user, "");
                return Response.status((Response.Status)Response.Status.OK).build();
            }
        } else {
            String err = "<br/><br/><font style='color:red'>You do not have valid license for 'Auto Numbered Headings' plugin. Please purchase or renew your license.</font><br/>";
            this.licenseError(err, user, "");
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        Space space = this.pageManager.getPage((long)Integer.parseInt(pageId)).getSpace();
        ConfluenceBandanaContext cfc = new ConfluenceBandanaContext(space);
        if (numFormat == null) {
            numFormat = "Decimal";
        }
        if (numFormat.contains("Default")) {
            numFormat = "Decimal";
        }
        if (numLevel == null) {
            numLevel = "4";
        }
        numTitles = numTitles == null ? "false" : "true";
        numOnlyTitles = numOnlyTitles == null ? "false" : "true";
        if (excludePages == null) {
            excludePages = "";
        }
        removeNum = removeNum == null ? "false" : "true";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("num-format", numFormat);
        params.put("num-level", numLevel);
        params.put("excluded_pages", excludePages);
        params.put("remove-auto-numhead", removeNum);
        params.put("num-titles", numTitles);
        params.put("num-onlytitles", numOnlyTitles);
        if (removeNum.contains("true")) {
            this.removeNumberedHeadings(space.getHomePage().getSortedChildren(), params);
        } else {
            this.updateNumberedHeadingsOfSpace(space, params);
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    public void updateNumberedHeadingsOfSpace(Space space, Map<String, String> params) {
        String title_regex;
        NumberFormat decimal_alphabetic;
        String title_prev_regex;
        Page homePage = space.getHomePage();
        String nextpage_starting_number = "";
        String nextpage_title_number = "";
        String excludedPages = params.get("excluded_pages");
        excludedPages = excludedPages + ",";
        int page_level = 1;
        int chapter_count = 1;
        int[] chapter_num = new int[6];
        if (params.get("num-format").contains("Alpha")) {
            title_prev_regex = "^[\\d|\\.]+ ";
            decimal_alphabetic = new AlphabeticalFormat();
            title_regex = "^[A-Z]\\.[\\d|\\.]* ";
        } else {
            title_prev_regex = "^[A-Z]\\.[\\d|\\.]* ";
            decimal_alphabetic = new DecimalFormat();
            title_regex = "^[\\d|\\.]+ ";
        }
        for (int i = 0; i < 6; ++i) {
            chapter_num[i] = 0;
        }
        chapter_num[0] = chapter_count;
        boolean page_is_blank = true;
        List pages = homePage.getSortedChildren();
        for (Page page : pages) {
            Page original_page2;
            String regex;
            String body = page.getBodyAsString();
            String newBody = "";
            String title = page.getTitle();
            String newTitle = title.replaceAll(title_prev_regex, "");
            newTitle = newTitle.replaceAll(title_regex, "");
            page_is_blank = true;
            if (params.get("num-titles").contains("true") || params.get("num-onlytitles").contains("true")) {
                newTitle = decimal_alphabetic.generate_head_number(chapter_num, 1) + ". " + newTitle;
            }
            if (excludedPages.contains(title + ",")) {
                if (body.contains(" ac:name=\"hvautonumheadmacro\"")) {
                    newBody = "<ac:structured-macro ac:name=\"hvautonumheadmacro\"><ac:parameter ac:name=\"num-format\">";
                    newBody = newBody + params.get("num-format") + "</ac:parameter><ac:parameter ac:name=\"starting-number\">";
                    newBody = newBody + Integer.toString(chapter_count) + "</ac:parameter><ac:parameter ac:name=\"hv-autonum-enable\">false</ac:parameter><ac:parameter ac:name=\"hv-page-level\">";
                    newBody = newBody + Integer.toString(page_level) + "</ac:parameter><ac:parameter ac:name=\"num-level\">";
                    newBody = newBody + params.get("num-level") + "</ac:parameter><ac:rich-text-body>";
                    regex = "<ac:structured-macro ac:name=\"hvautonumheadmacro\"(((?!ac:rich-text-body).)+)<ac:rich-text-body>";
                    newBody = body.replaceAll(regex, newBody);
                }
                if (body.equals(newBody) && title.equals(newTitle)) continue;
                try {
                    original_page2 = (Page)page.clone();
                    page.setBodyAsString(newBody);
                    page.setTitle(newTitle);
                    this.pageManager.saveContentEntity((ContentEntityObject)page, (ContentEntityObject)original_page2, null);
                }
                catch (Exception original_page2) {}
                continue;
            }
            if (body.contains(" ac:name=\"hvautonumheadmacro\"")) {
                if (params.get("num-onlytitles").contains("false")) {
                    newBody = "<ac:structured-macro ac:name=\"hvautonumheadmacro\"><ac:parameter ac:name=\"num-format\">";
                    newBody = newBody + params.get("num-format") + "</ac:parameter><ac:parameter ac:name=\"starting-number\">";
                    newBody = newBody + Integer.toString(chapter_count) + "</ac:parameter><ac:parameter ac:name=\"hv-autonum-enable\">true</ac:parameter><ac:parameter ac:name=\"hv-page-level\">";
                    newBody = newBody + Integer.toString(page_level) + "</ac:parameter><ac:parameter ac:name=\"num-level\">";
                    newBody = newBody + params.get("num-level") + "</ac:parameter><ac:rich-text-body>";
                    regex = "<ac:structured-macro ac:name=\"hvautonumheadmacro\"(((?!ac:rich-text-body).)+)<ac:rich-text-body>";
                    newBody = body.replaceAll(regex, newBody);
                } else {
                    newBody = "<ac:structured-macro ac:name=\"hvautonumheadmacro\"><ac:parameter ac:name=\"num-format\">";
                    newBody = newBody + params.get("num-format") + "</ac:parameter><ac:parameter ac:name=\"starting-number\">";
                    newBody = newBody + Integer.toString(chapter_count) + "</ac:parameter><ac:parameter ac:name=\"hv-autonum-enable\">false</ac:parameter><ac:parameter ac:name=\"hv-page-level\">";
                    newBody = newBody + Integer.toString(page_level) + "</ac:parameter><ac:parameter ac:name=\"num-level\">";
                    newBody = newBody + params.get("num-level") + "</ac:parameter><ac:rich-text-body>";
                    regex = "<ac:structured-macro ac:name=\"hvautonumheadmacro\"(((?!ac:rich-text-body).)+)<ac:rich-text-body>";
                    newBody = body.replaceAll(regex, newBody);
                }
            } else if (params.get("num-onlytitles").contains("false")) {
                newBody = "<ac:structured-macro ac:name=\"hvautonumheadmacro\"><ac:parameter ac:name=\"num-format\">";
                newBody = newBody + params.get("num-format") + "</ac:parameter><ac:parameter ac:name=\"starting-number\">";
                newBody = newBody + Integer.toString(chapter_count) + "</ac:parameter><ac:parameter ac:name=\"hv-autonum-enable\">true</ac:parameter><ac:parameter ac:name=\"hv-page-level\">";
                newBody = newBody + Integer.toString(page_level) + "</ac:parameter><ac:parameter ac:name=\"num-level\">";
                newBody = newBody + params.get("num-level") + "</ac:parameter><ac:rich-text-body>";
                newBody = newBody + body;
                newBody = newBody + "</ac:rich-text-body></ac:structured-macro>";
            } else {
                newBody = body;
            }
            if (!body.equals(newBody) || !title.equals(newTitle)) {
                try {
                    original_page2 = (Page)page.clone();
                    page.setBodyAsString(newBody);
                    page.setTitle(newTitle);
                    this.pageManager.saveContentEntity((ContentEntityObject)page, (ContentEntityObject)original_page2, null);
                }
                catch (Exception original_page3) {
                    // empty catch block
                }
            }
            String html = "";
            DefaultConversionContext context = new DefaultConversionContext((RenderContext)page.toPageContext());
            try {
                html = this.xhtmlUtils.convertStorageToView(newBody, (ConversionContext)context);
            }
            catch (XMLStreamException xMLStreamException) {
            }
            catch (XhtmlException xhtmlException) {
                // empty catch block
            }
            Pattern pattern = Pattern.compile("<span class=\"hv-head-number\">(.*?)?</span>", 33);
            Matcher matcher = pattern.matcher(html);
            while (matcher.find()) {
                nextpage_starting_number = matcher.group(1);
                page_is_blank = false;
            }
            if (page_is_blank) {
                nextpage_starting_number = Integer.toString(chapter_count) + ".0.0.0.0.0";
            }
            params.put("starting-number", Integer.toString(chapter_count));
            params.put("hv-page-level", Integer.toString(page_level));
            int[] heading_count = new int[6];
            heading_count = this.assign_heading_count(nextpage_starting_number);
            nextpage_title_number = "";
            nextpage_starting_number = "";
            int level_of_numbering = 4;
            try {
                level_of_numbering = Integer.valueOf(params.get("num-level"));
            }
            catch (NumberFormatException e) {
                level_of_numbering = 4;
            }
            for (int i = 0; i < level_of_numbering; ++i) {
                if (i > 1) {
                    nextpage_starting_number = nextpage_starting_number + ".";
                }
                if (i == page_level) {
                    if (i > 1) {
                        nextpage_title_number = nextpage_title_number + ".";
                    }
                    nextpage_title_number = nextpage_title_number + Integer.toString(heading_count[i] + 1);
                }
                if (i < page_level) {
                    if (i > 1) {
                        nextpage_title_number = nextpage_title_number + ".";
                    }
                    nextpage_title_number = nextpage_title_number + decimal_alphabetic.generate_head_number(heading_count, i + 1);
                }
                nextpage_starting_number = nextpage_starting_number + Integer.toString(heading_count[i]);
                if (i != 0) continue;
                nextpage_title_number = nextpage_title_number + ".";
                nextpage_starting_number = nextpage_starting_number + ".";
            }
            if (params.get("num-titles").contains("true") || params.get("num-onlytitles").contains("true")) {
                nextpage_starting_number = nextpage_title_number;
            }
            nextpage_starting_number = this.updateNumberedHeadingOfChildPages(params, nextpage_starting_number, nextpage_title_number, page.getSortedChildren(), page_level + 1);
            chapter_num[0] = ++chapter_count;
        }
    }

    public String updateNumberedHeadingOfChildPages(Map<String, String> params, String start_num_page, String page_title_num, List<Page> children, int page_level) {
        String title_regex;
        NumberFormat decimal_alphabetic;
        String title_prev_regex;
        String nextpage_starting_number = start_num_page;
        String nextpage_title_number = page_title_num;
        String nextsamelevelpage_title_number = "";
        String excludedPages = params.get("excluded_pages");
        excludedPages = excludedPages + ",";
        if (params.get("num-format").contains("Alpha")) {
            title_prev_regex = "^[\\d|\\.]+ ";
            decimal_alphabetic = new AlphabeticalFormat();
            title_regex = "^[A-Z]\\.[\\d|\\.]* ";
        } else {
            title_prev_regex = "^[A-Z]\\.[\\d|\\.]* ";
            decimal_alphabetic = new DecimalFormat();
            title_regex = "^[\\d|\\.]+ ";
        }
        int page_position = 1;
        boolean page_is_blank = true;
        for (Page page : children) {
            String body = page.getBodyAsString();
            String newBody = "";
            String title = page.getTitle();
            String newTitle = title.replaceAll(title_prev_regex, "");
            newTitle = newTitle.replaceAll(title_regex, "");
            page_is_blank = true;
            if (params.get("num-titles").contains("true") || params.get("num-onlytitles").contains("true")) {
                newTitle = nextpage_title_number + " " + newTitle;
            }
            if (excludedPages.contains(title + ",")) continue;
            if (body.contains(" ac:name=\"hvautonumheadmacro\"")) {
                String regex;
                if (params.get("num-onlytitles").contains("false")) {
                    newBody = "<ac:structured-macro ac:name=\"hvautonumheadmacro\"><ac:parameter ac:name=\"num-format\">";
                    newBody = newBody + params.get("num-format") + "</ac:parameter><ac:parameter ac:name=\"starting-number\">";
                    newBody = newBody + nextpage_starting_number + "</ac:parameter><ac:parameter ac:name=\"hv-autonum-enable\">true</ac:parameter><ac:parameter ac:name=\"hv-page-level\">";
                    newBody = newBody + Integer.toString(page_level) + "</ac:parameter><ac:parameter ac:name=\"num-level\">";
                    newBody = newBody + params.get("num-level") + "</ac:parameter><ac:rich-text-body>";
                    regex = "<ac:structured-macro ac:name=\"hvautonumheadmacro\"(((?!ac:rich-text-body).)+)<ac:rich-text-body>";
                    newBody = body.replaceAll(regex, newBody);
                } else {
                    newBody = "<ac:structured-macro ac:name=\"hvautonumheadmacro\"><ac:parameter ac:name=\"num-format\">";
                    newBody = newBody + params.get("num-format") + "</ac:parameter><ac:parameter ac:name=\"starting-number\">";
                    newBody = newBody + nextpage_starting_number + "</ac:parameter><ac:parameter ac:name=\"hv-autonum-enable\">false</ac:parameter><ac:parameter ac:name=\"hv-page-level\">";
                    newBody = newBody + Integer.toString(page_level) + "</ac:parameter><ac:parameter ac:name=\"num-level\">";
                    newBody = newBody + params.get("num-level") + "</ac:parameter><ac:rich-text-body>";
                    regex = "<ac:structured-macro ac:name=\"hvautonumheadmacro\"(((?!ac:rich-text-body).)+)<ac:rich-text-body>";
                    newBody = body.replaceAll(regex, newBody);
                }
            } else if (params.get("num-onlytitles").contains("false")) {
                newBody = "<ac:structured-macro ac:name=\"hvautonumheadmacro\"><ac:parameter ac:name=\"num-format\">";
                newBody = newBody + params.get("num-format") + "</ac:parameter><ac:parameter ac:name=\"starting-number\">";
                newBody = newBody + nextpage_starting_number + "</ac:parameter><ac:parameter ac:name=\"hv-autonum-enable\">true</ac:parameter><ac:parameter ac:name=\"hv-page-level\">";
                newBody = newBody + Integer.toString(page_level) + "</ac:parameter><ac:parameter ac:name=\"num-level\">";
                newBody = newBody + params.get("num-level") + "</ac:parameter><ac:rich-text-body>";
                newBody = newBody + body;
                newBody = newBody + "</ac:rich-text-body></ac:structured-macro>";
            } else {
                newBody = body;
            }
            if (!body.equals(newBody) || !title.equals(newTitle)) {
                try {
                    Page original_page = (Page)page.clone();
                    page.setBodyAsString(newBody);
                    page.setTitle(newTitle);
                    page.setPosition(Integer.valueOf(page_position));
                    this.pageManager.saveContentEntity((ContentEntityObject)page, (ContentEntityObject)original_page, null);
                }
                catch (Exception original_page) {
                    // empty catch block
                }
            }
            String html = "";
            DefaultConversionContext context = new DefaultConversionContext((RenderContext)page.toPageContext());
            try {
                html = this.xhtmlUtils.convertStorageToView(newBody, (ConversionContext)context);
            }
            catch (XMLStreamException xMLStreamException) {
            }
            catch (XhtmlException xhtmlException) {
                // empty catch block
            }
            Pattern pattern = Pattern.compile("<span class=\"hv-head-number\">(.*?)?</span>", 33);
            Matcher matcher = pattern.matcher(html);
            while (matcher.find()) {
                nextpage_starting_number = matcher.group(1);
                page_is_blank = false;
            }
            if (page_is_blank) {
                // empty if block
            }
            params.put("starting-number", start_num_page);
            params.put("hv-page-level", Integer.toString(page_level));
            int[] heading_count = new int[6];
            heading_count = this.assign_heading_count(nextpage_starting_number);
            nextpage_title_number = "";
            nextpage_starting_number = "";
            nextsamelevelpage_title_number = "";
            int level_of_numbering = 4;
            try {
                level_of_numbering = Integer.valueOf(params.get("num-level"));
            }
            catch (NumberFormatException e) {
                level_of_numbering = 4;
            }
            for (int i = 0; i < level_of_numbering; ++i) {
                if (i > 1) {
                    nextpage_starting_number = nextpage_starting_number + ".";
                }
                if (i == page_level) {
                    if (i > 1) {
                        nextpage_title_number = nextpage_title_number + ".";
                    }
                    nextpage_title_number = nextpage_title_number + Integer.toString(heading_count[i] + 1);
                }
                if (i < page_level) {
                    if (i > 1) {
                        nextpage_title_number = nextpage_title_number + ".";
                        nextsamelevelpage_title_number = nextsamelevelpage_title_number + ".";
                    }
                    nextpage_title_number = nextpage_title_number + decimal_alphabetic.generate_head_number(heading_count, i + 1);
                    nextsamelevelpage_title_number = i == page_level - 1 ? nextsamelevelpage_title_number + Integer.toString(heading_count[i] + 1) : nextsamelevelpage_title_number + decimal_alphabetic.generate_head_number(heading_count, i + 1);
                }
                nextpage_starting_number = nextpage_starting_number + Integer.toString(heading_count[i]);
                if (i != 0) continue;
                nextpage_title_number = nextpage_title_number + ".";
                nextpage_starting_number = nextpage_starting_number + ".";
                nextsamelevelpage_title_number = nextsamelevelpage_title_number + ".";
            }
            if (params.get("num-titles").contains("true") || params.get("num-onlytitles").contains("true")) {
                nextpage_starting_number = nextpage_title_number;
            }
            nextpage_starting_number = this.updateNumberedHeadingOfChildPages(params, nextpage_starting_number, nextpage_title_number, page.getSortedChildren(), page_level + 1);
            nextpage_title_number = nextsamelevelpage_title_number;
            if (params.get("num-titles").contains("true") || params.get("num-onlytitles").contains("true")) {
                nextpage_starting_number = nextpage_title_number;
            }
            ++page_position;
        }
        return nextpage_starting_number;
    }

    public void removeNumberedHeadings(List<Page> pages, Map<String, String> params) {
        String title_regex;
        NumberFormat decimal_alphabetic;
        String title_prev_regex;
        boolean update_page_titles = false;
        if (params.get("num-titles").contains("true")) {
            update_page_titles = true;
        }
        String excludedPages = params.get("excluded_pages");
        excludedPages = excludedPages + ",";
        if (params.get("num-format").contains("Alpha")) {
            title_prev_regex = "^[\\d|\\.]+ ";
            decimal_alphabetic = new AlphabeticalFormat();
            title_regex = "^[A-Z]\\.[\\d|\\.]* ";
        } else {
            title_prev_regex = "^[A-Z]\\.[\\d|\\.]* ";
            decimal_alphabetic = new DecimalFormat();
            title_regex = "^[\\d|\\.]+ ";
        }
        int page_position = 1;
        for (Page page : pages) {
            String title;
            String body = page.getBodyAsString();
            String newBody = "";
            String newTitle = title = page.getTitle();
            if (params.get("num-titles").contains("true") || params.get("num-onlytitles").contains("true")) {
                newTitle = newTitle.replaceAll(title_prev_regex, "");
                newTitle = newTitle.replaceAll(title_regex, "");
            }
            if (excludedPages.contains(title + ",")) continue;
            if (body.contains("ac:name=\"hvautonumheadmacro\"")) {
                int lastIndex = body.lastIndexOf("</ac:rich-text-body></ac:structured-macro>");
                if (body.startsWith("<ac:structured-macro ac:name=\"hvautonumheadmacro\"") && body.endsWith("</ac:rich-text-body></ac:structured-macro>") && lastIndex > 0) {
                    String regex = "<ac:structured-macro ac:name=\"hvautonumheadmacro\"(((?!ac:rich-text-body).)+)<ac:rich-text-body>";
                    newBody = body.replaceFirst(regex, "");
                    lastIndex = newBody.lastIndexOf("</ac:rich-text-body></ac:structured-macro>");
                    newBody = newBody.substring(0, lastIndex);
                } else if (body.indexOf("<ac:rich-text-body>") > body.indexOf("ac:name=\"hvautonumheadmacro\"")) {
                    int richTextIndex = body.indexOf("<ac:rich-text-body>");
                    int nextRichTextIndex = body.indexOf("<ac:rich-text-body>", richTextIndex + 20);
                    int richTextEndIndex = body.indexOf("</ac:rich-text-body>", richTextIndex + 20);
                    while (nextRichTextIndex != -1 && richTextEndIndex > nextRichTextIndex) {
                        nextRichTextIndex = body.indexOf("<ac:rich-text-body>", nextRichTextIndex + 20);
                        richTextEndIndex = body.indexOf("</ac:rich-text-body>", richTextEndIndex + 20);
                    }
                    if (richTextEndIndex == body.lastIndexOf("</ac:rich-text-body></ac:structured-macro>") && nextRichTextIndex == -1) {
                        String regex = "<ac:structured-macro ac:name=\"hvautonumheadmacro\"(((?!ac:rich-text-body).)+)<ac:rich-text-body>";
                        newBody = body.replaceFirst(regex, "");
                        lastIndex = newBody.lastIndexOf("</ac:rich-text-body></ac:structured-macro>");
                        String textAfterMacro = "";
                        if (newBody.length() > lastIndex + 42) {
                            textAfterMacro = newBody.substring(lastIndex + 42);
                        }
                        newBody = newBody.substring(0, lastIndex);
                        newBody = newBody + textAfterMacro;
                    } else {
                        newBody = body.contains("\"hv-autonum-enable\">") ? body.replace("hv-autonum-enable\">true", "hv-autonum-enable\">false") : body.replace("<ac:parameter ac:name=\"hv-page-level\"", "<ac:parameter ac:name=\"hv-autonum-enable\">false</ac:parameter><ac:parameter ac:name=\"hv-page-level\"");
                    }
                } else {
                    newBody = body.contains("\"hv-autonum-enable\">") ? body.replace("hv-autonum-enable\">true", "hv-autonum-enable\">false") : body.replace("<ac:parameter ac:name=\"hv-page-level\"", "<ac:parameter ac:name=\"hv-autonum-enable\">false</ac:parameter><ac:parameter ac:name=\"hv-page-level\"");
                }
            } else {
                newBody = body;
            }
            if (!body.equals(newBody) || !title.equals(newTitle)) {
                try {
                    Page original_page = (Page)page.clone();
                    page.setBodyAsString(newBody);
                    page.setTitle(newTitle);
                    page.setPosition(Integer.valueOf(page_position));
                    this.pageManager.saveContentEntity((ContentEntityObject)page, (ContentEntityObject)original_page, null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.removeNumberedHeadings(page.getSortedChildren(), params);
            ++page_position;
        }
    }

    public int[] assign_heading_count(String start_with) {
        int[] starting_number = new int[6];
        for (int i = 0; i < 6; ++i) {
            starting_number[i] = 0;
        }
        if (start_with != null && !start_with.trim().isEmpty()) {
            start_with = start_with.trim();
            String[] parts = start_with.split("\\.");
            for (int i = 0; i < parts.length; ++i) {
                char character;
                if (this.isInteger(parts[i])) {
                    try {
                        starting_number[i] = Integer.valueOf(parts[i]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (!Character.isLetter(parts[i].charAt(0))) continue;
                char ascii = character = parts[i].substring(0, 1).toUpperCase(Locale.ENGLISH).charAt(0);
                starting_number[i] = ascii - 64;
                if (parts[i].length() <= 1 || !Character.isLetter(parts[i].charAt(1))) continue;
                ascii = character = parts[i].substring(1, 2).toUpperCase(Locale.ENGLISH).charAt(0);
                int n = i;
                starting_number[n] = starting_number[n] + (ascii - 64);
            }
        }
        return Arrays.copyOf(starting_number, starting_number.length);
    }

    public boolean isInteger(String str) {
        if (str.isEmpty()) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (!(i == 0 && str.charAt(i) == '-' ? str.length() == 1 : Character.digit(str.charAt(i), 10) < 0)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String transform(String htmlContent, String xslResource) {
        StringWriter outWriter = new StringWriter();
        htmlContent = "<html xmlns:html=\"http://www.w3.org/1999/xhtml\">" + htmlContent + "</html>";
        htmlContent = htmlContent.replaceAll("<ac:structured-macro ", "<ac_structured-macro ");
        htmlContent = htmlContent.replaceAll("</ac:structured-macro>", "</ac_structured-macro>");
        htmlContent = htmlContent.replaceAll("ac:name=\"hvautonumheadmacro\"", "ac_name=\"hvautonumheadmacro\"");
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbFactory.newDocumentBuilder();
            db.setEntityResolver(new AutoNumEntityResolver());
            StringReader xhtmlSR = new StringReader(htmlContent);
            Document doc = db.parse(new InputSource(xhtmlSR));
            DOMSource xmlSource = new DOMSource(doc.getDocumentElement());
            InputStream xsl_is = this.getClass().getResourceAsStream(xslResource);
            StreamSource xsltSource = new StreamSource(xsl_is);
            StreamResult result = new StreamResult(outWriter);
            TransformerFactory transFact = TransformerFactory.newInstance();
            Transformer trans = transFact.newTransformer(xsltSource);
            trans.transform(xmlSource, result);
        }
        catch (TransformerConfigurationException e) {
            LOG.error((Object)"transform()", (Throwable)e);
        }
        catch (TransformerException e) {
            LOG.error((Object)"transform()", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            LOG.error((Object)"transform()", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)"transform()", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            LOG.error((Object)"transform()", (Throwable)e);
        }
        catch (SAXException e) {
            LOG.error((Object)"transform()", (Throwable)e);
        }
        finally {
            LOG.debug((Object)("XSL File is: " + xslResource));
        }
        htmlContent = outWriter.toString();
        htmlContent = htmlContent.replaceAll("<html xmlns:html=\"http://www.w3.org/1999/xhtml\">", "");
        htmlContent = htmlContent.replaceAll("</html>", "");
        htmlContent = htmlContent.replaceAll("<ac_structured-macro ", "<ac:structured-macro ");
        htmlContent = htmlContent.replaceAll("</ac_structured-macro>", "</ac:structured-macro>");
        htmlContent = htmlContent.replaceAll("ac_name=\"hvautonumheadmacro\"", "ac:name=\"hvautonumheadmacro\"");
        return htmlContent;
    }

    @GET
    @Path(value="/autonumconfig/status")
    @Produces(value={"application/xml", "application/json"})
    public Response Status() {
        JSONObject obj = new JSONObject();
        return Response.ok((Object)obj.toString()).build();
    }

    @GET
    @Path(value="/unique")
    @Produces(value={"application/json", "application/xml"})
    public Response getUniqueId() {
        return Response.ok((Object)new UniqueId(this.generateUniqueId())).build();
    }

    private String generateUniqueId() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    private void licenseError(String msg, UserProfile user, String spaceKey) {
        String smtp_from = user.getEmail();
        if (smtp_from.contains("@")) {
            smtp_from = smtp_from.substring(smtp_from.indexOf("@"));
            smtp_from = "no-reply" + smtp_from;
        }
        try {
            ConfluenceMailQueueItem autonumheadmail = new ConfluenceMailQueueItem(user.getEmail(), "Auto Numbered Heading for Space", msg.toString(), "text/html");
            autonumheadmail.setFromName("Confluence Wiki");
            if (autonumheadmail.getFromAddress() == null || autonumheadmail.getFromAddress().isEmpty()) {
                autonumheadmail.setFromAddress(smtp_from);
            }
            this.taskManager.addTask("mail", (Task & Serializable)() -> autonumheadmail.send());
            LOG.debug((Object)"Auto numbered heading Mail Sending Done");
        }
        catch (Exception e) {
            LOG.error((Object)"ERROR:Auto Numbered Heading:Error in sending mail", (Throwable)e);
        }
    }

    public void setBandanaManager(BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
        LOG.debug((Object)("BandanaManager: " + this.bandanaManager));
    }

    public void setxhtmlContent(XhtmlContent xhtmlUtils) {
        this.xhtmlUtils = xhtmlUtils;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
        LOG.debug((Object)("PageManager: " + this.pageManager));
    }

    public void setAttachmentManager(AttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
        LOG.debug((Object)("AttachmentManager: " + this.attachmentManager));
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
        LOG.debug((Object)("SpaceManager: " + this.spaceManager));
    }

    public void setPluginLicenseManager(PluginLicenseManager pluginLicenseManager) {
        this.pluginLicenseManager = pluginLicenseManager;
        LOG.debug((Object)("PluginLicenseManager: " + this.pluginLicenseManager));
    }

    public void setImportExportManager(ImportExportManager importExportManager) {
        this.importExportManager = importExportManager;
        LOG.debug((Object)("ImportExportManager: " + this.importExportManager));
    }

    public void setApplicationProperties(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
        LOG.debug((Object)("ApplicationProperties: " + this.applicationProperties));
    }

    public void setGateKeeper(GateKeeper gateKeeper) {
        this.gateKeeper = gateKeeper;
        LOG.debug((Object)("GateKeeper: " + this.gateKeeper));
    }

    public void setMultiQueueTaskManager(MultiQueueTaskManager taskManager) {
        this.taskManager = taskManager;
        LOG.debug((Object)("TaskManager: " + this.taskManager));
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
        LOG.debug((Object)("UserManager: " + this.userManager));
    }
}

