/*
 * Decompiled with CFR 0.152.
 */
package com.hivestone.confluence.plugins.hcms.util;

import com.hivestone.confluence.plugins.hcms.util.AutoNumberedHeadingConfiguration;
import java.util.Arrays;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HeadingNumberAllocator {
    private AutoNumberedHeadingConfiguration config;
    private String last_num = "";
    private int[] heading_count;
    private int previous_level = 0;

    public HeadingNumberAllocator(AutoNumberedHeadingConfiguration config) {
        this.config = config;
        this.heading_count = config.getStartingNumber();
        for (int i = 0; i < this.heading_count.length; ++i) {
            if (this.heading_count[i] <= 0) continue;
            ++this.previous_level;
        }
    }

    public String allocateNumbers(String body) {
        Pattern pattern = Pattern.compile("(<h[1-6](.*?)?>(<a name=.*?</a>)?)((.)*?</h[1-6]>)", 33);
        Matcher matcher = pattern.matcher(body);
        StringBuffer resultString = new StringBuffer();
        while (matcher.find()) {
            MatchResult matchResult = matcher.toMatchResult();
            int level = this.getMatchedHeadingLevel(body, matchResult);
            if (level > this.config.getNumberingLevel()) continue;
            String headingNumber = this.findNumberOfHeading(level);
            headingNumber = !headingNumber.isEmpty() ? "<span class=\"hv-head-number\">" + headingNumber + "</span>" : "";
            matcher.appendReplacement(resultString, "$1" + headingNumber + "$4");
        }
        matcher.appendTail(resultString);
        return resultString.toString();
    }

    public int getMatchedHeadingLevel(String body, MatchResult matchResult) {
        int heading = Character.getNumericValue(body.charAt(matchResult.start() + 2));
        int page_level = this.config.getCurrentPageLevel();
        if (!body.contains("<h1 ") && !body.contains("<h1>")) {
            --heading;
        }
        return heading + page_level;
    }

    public String findNumberOfHeading(int currentLevel) {
        StringBuffer number = new StringBuffer();
        if (this.previous_level > currentLevel) {
            this.resetLevelCounting(currentLevel);
        }
        int n = currentLevel - 1;
        this.heading_count[n] = this.heading_count[n] + 1;
        if (currentLevel <= this.config.getNumberingLevel()) {
            for (int i = 0; i < currentLevel; ++i) {
                if (i > 1) {
                    number.append(".");
                }
                if (i + 1 > this.previous_level && i + 1 < currentLevel) {
                    int n2 = i;
                    this.heading_count[n2] = this.heading_count[n2] + 1;
                }
                number.append(this.config.getNumberingFormat().generate_head_number(this.heading_count, i + 1));
                if (i != 0) continue;
                number.append(".");
            }
        }
        number.append(" ");
        this.last_num = number.toString();
        this.previous_level = currentLevel;
        return number.toString();
    }

    public void resetLevelCounting(int currentLevel) {
        for (int i = currentLevel; i < 6; ++i) {
            this.heading_count[i] = 0;
        }
    }

    public String getLastNumberOfPage() {
        return this.last_num;
    }

    public int getPreviousLevel() {
        return this.previous_level;
    }

    public int[] getHeadingCount() {
        return Arrays.copyOf(this.heading_count, this.heading_count.length);
    }
}

