/*
 * Decompiled with CFR 0.152.
 */
package com.hivestone.confluence.plugins.hcms.listener;

import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.event.events.content.page.PageCreateEvent;
import com.atlassian.confluence.event.events.content.page.PageUpdateEvent;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.hivestone.confluence.plugins.hcms.common.PageObjectCounter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public class PageEventListener
implements DisposableBean {
    private static final Logger LOG = LoggerFactory.getLogger(PageEventListener.class);
    protected PageObjectCounter pageObjectCounter;
    protected EventPublisher eventPublisher;
    protected XhtmlContent xhtmlContent;
    protected BandanaManager bandanaManager;

    public PageEventListener(EventPublisher eventPublisher, XhtmlContent xhtmlContent, BandanaManager bandanaManager) {
        this.eventPublisher = eventPublisher;
        this.xhtmlContent = xhtmlContent;
        this.bandanaManager = bandanaManager;
        this.pageObjectCounter = PageObjectCounter.getInstance(this.xhtmlContent, this.bandanaManager);
        eventPublisher.register((Object)this);
    }

    @EventListener
    public void pageCreateEvent(PageCreateEvent event) {
        this.pageObjectCounter.updatePageObjectCount(event.getPage());
    }

    @EventListener
    public void pageUpdateEvent(PageUpdateEvent event) {
        this.pageObjectCounter.updatePageObjectCount(event.getPage());
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }
}

