/**
 * Generate Unique ID for macros
 */

AJS.bind("init.rte", function () {
  var $ = AJS.$, overrides = {};

  getUniqueId = function () {
    var uId = null;
    $.ajax({
      type: 'GET',
      async: false,
      url: AJS.Confluence.getContextPath() +
        '/rest/hcms_auto_num_headings/1.0/book/unique/',
      dataType: 'json',
      beforeSend : function(xhr){
         xhr.setRequestHeader( 'X-Atlassian-Token', 'no-check');
      },
      success: function (data, result) {
        uId = data.id;
      }
    });

    return uId;
  };

  overrides.fields = {
    "string": {
      "uniqueId": function (param) {
        return AJS.MacroBrowser.ParameterFields["_hidden"](param, {});
      }
    }
  };

  overrides.beforeParamsSet = function (params, macro, sharedParamMap) {
    if (!params["uniqueId"]) {
      params["uniqueId"] = getUniqueId();
    }

    return params;
  };

  AJS.MacroBrowser.setMacroJsOverride("captionmacro", overrides);
});
