/*
 * Decompiled with CFR 0.152.
 */
package com.hivestone.confluence.plugins.hcms.macro;

import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.hivestone.confluence.plugins.hcms.common.CaptionHandler;
import java.util.Map;
import org.apache.log4j.Logger;

public class CaptionMacro
implements Macro {
    private static Logger LOG = Logger.getLogger(CaptionMacro.class);
    private XhtmlContent xhtmlContent;
    private BandanaManager bandanaManager;

    public CaptionMacro(XhtmlContent xhtmlContent, BandanaManager bandanaManager) {
        this.xhtmlContent = xhtmlContent;
        this.bandanaManager = bandanaManager;
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.RICH_TEXT;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    public String execute(Map<String, String> params, String body, ConversionContext context) throws MacroExecutionException {
        Page page = (Page)context.getEntity();
        CaptionHandler captionHandler = new CaptionHandler(page, this.bandanaManager, this.xhtmlContent);
        captionHandler.loadPage();
        String macroUid = params.get("uniqueId");
        String autoNumber = captionHandler.getAutoNumber(macroUid);
        StringBuilder xhtml = new StringBuilder();
        String id = params.get("captionOf") + "-" + macroUid;
        xhtml.append("<span class=\"content-title\" id=\"" + id + "\"><strong>");
        xhtml.append(params.get("captionOf"));
        xhtml.append(" ");
        xhtml.append(autoNumber);
        xhtml.append(":</strong> ");
        String title = body.trim().replaceAll("<p>", "");
        title = title.replaceAll("</p>", "");
        xhtml.append(title);
        xhtml.append("</span>");
        return xhtml.toString();
    }
}

