/*
 * Decompiled with CFR 0.152.
 */
package com.hivestone.confluence.plugins.hcms.common;

import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.hivestone.confluence.plugins.hcms.common.CaptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageObjectCounter {
    private static final Logger LOG = LoggerFactory.getLogger(PageObjectCounter.class);
    private XhtmlContent xhtmlContent;
    private BandanaManager bandanaManager;

    private PageObjectCounter() {
    }

    private PageObjectCounter(XhtmlContent xhtmlContent, BandanaManager bandanaManager) {
        this.xhtmlContent = xhtmlContent;
        this.bandanaManager = bandanaManager;
    }

    public static PageObjectCounter getInstance(XhtmlContent xhtmlContent, BandanaManager bandanaManager) {
        return SingletonHolder.getPageObjectCounter(xhtmlContent, bandanaManager);
    }

    public void updatePageObjectCount(Page page) {
        LOG.debug("Updating page object count for page: " + page.getId());
        CaptionHandler captionHandler = new CaptionHandler(page, this.bandanaManager, this.xhtmlContent);
        captionHandler.updateObjectCount();
    }

    private static class SingletonHolder {
        private static PageObjectCounter INSTANCE;

        private SingletonHolder() {
        }

        public static synchronized PageObjectCounter getPageObjectCounter(XhtmlContent xhtmlContent, BandanaManager bandanaManager) {
            if (INSTANCE == null) {
                INSTANCE = new PageObjectCounter(xhtmlContent, bandanaManager);
            }
            return INSTANCE;
        }
    }
}

