/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.jakarta.util;

import com.enhancera.accesslog.common.servlet.ServletUtils;
import com.enhancera.accesslog.jakarta.util.JakartaRequestUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Optional;

public class JakartaServletUtils
implements ServletUtils {
    @Override
    public Optional<String> getRequestHeader(Object httpServletRequest, String header) {
        if (!(httpServletRequest instanceof HttpServletRequest)) {
            return Optional.empty();
        }
        HttpServletRequest jakartaHttpServletRequest = (HttpServletRequest)httpServletRequest;
        return Optional.of(jakartaHttpServletRequest.getHeader(header));
    }

    @Override
    public Optional<String> getRequestParameter(Object httpServletRequest, String parameter) {
        if (!(httpServletRequest instanceof HttpServletRequest)) {
            return Optional.empty();
        }
        HttpServletRequest jakartaHttpServletRequest = (HttpServletRequest)httpServletRequest;
        return Optional.of(jakartaHttpServletRequest.getParameter(parameter));
    }

    @Override
    public Optional<String> extractIpAddressFromRequest(Object httpServletRequest) {
        if (!(httpServletRequest instanceof HttpServletRequest)) {
            return Optional.empty();
        }
        HttpServletRequest jakartaHttpServletRequest = (HttpServletRequest)httpServletRequest;
        return JakartaRequestUtils.extractIpAddress(jakartaHttpServletRequest);
    }

    @Override
    public Optional<String> getRequestContextPath(Object httpServletRequest) {
        if (!(httpServletRequest instanceof HttpServletRequest)) {
            return Optional.empty();
        }
        HttpServletRequest jakartaHttpServletRequest = (HttpServletRequest)httpServletRequest;
        return Optional.of(jakartaHttpServletRequest.getContextPath());
    }

    @Override
    public Optional<String> getRequestURI(Object httpServletRequest) {
        if (!(httpServletRequest instanceof HttpServletRequest)) {
            return Optional.empty();
        }
        HttpServletRequest jakartaHttpServletRequest = (HttpServletRequest)httpServletRequest;
        return Optional.of(jakartaHttpServletRequest.getRequestURI());
    }
}

