/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.jakarta.rest;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.enhancera.accesslog.common.rest.ConfigRestResourceExecutor;
import com.enhancera.accesslog.common.util.FormattingLogger;
import com.enhancera.accesslog.jakarta.JakartaHttpRequestAdapter;
import com.enhancera.accesslog.jakarta.rest.JakartaResponseAdapter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.Set;
import javax.annotation.Nullable;

@Path(value="/config")
@AdminOnly
public class JakartaConfigRestResource {
    private static final FormattingLogger log = FormattingLogger.getLogger(JakartaConfigRestResource.class);
    private final ConfigRestResourceExecutor executor;

    public JakartaConfigRestResource(ConfigRestResourceExecutor executor) {
        this.executor = executor;
    }

    @GET
    @Produces(value={"application/json", "application/xml"})
    public Response getConfig() {
        return JakartaResponseAdapter.toJakarta(this.executor.getConfig());
    }

    @POST
    @ReadOnlyAccessAllowed
    @Produces(value={"application/json", "application/xml"})
    public Response setConfig(@FormParam(value="retentionPeriod") int retentionPeriod, @FormParam(value="numberOfRecordsPerPage") int numberOfRecordsPerPage, @FormParam(value="sensitiveFields") Set<String> sensitiveFields, @FormParam(value="writeToSyslog") boolean writeToSyslog, @FormParam(value="syslogHost") String syslogHost, @Nullable @FormParam(value="syslogFacility") Integer syslogFacility, @Nullable @FormParam(value="syslogLevel") Integer syslogLevel, @FormParam(value="writeToFile") boolean writeToFile, @FormParam(value="filePath") String filePath, @FormParam(value="eventsConfigMap") String eventsConfigMapJson, @Context HttpServletRequest request) {
        return JakartaResponseAdapter.toJakarta(this.executor.setConfig(retentionPeriod, numberOfRecordsPerPage, sensitiveFields, writeToSyslog, syslogHost, syslogFacility, syslogLevel, writeToFile, filePath, eventsConfigMapJson, new JakartaHttpRequestAdapter(request)));
    }
}

