/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.jakarta;

import com.enhancera.accesslog.common.RecordCriteria;
import com.enhancera.accesslog.common.util.CollectionUtils;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.List;

public class JakartaRecordCriteriaFactory {
    private JakartaRecordCriteriaFactory() {
    }

    public static RecordCriteria create(HttpServletRequest request) {
        String query = request.getParameter("query");
        String fromTimeString = request.getParameter("fromTime");
        Long fromTime = Strings.isNullOrEmpty(fromTimeString) ? null : Long.valueOf(Long.parseLong(fromTimeString));
        String toTimeString = request.getParameter("toTime");
        Long toTime = Strings.isNullOrEmpty(toTimeString) ? null : Long.valueOf(Long.parseLong(toTimeString));
        Object[] usersArray = request.getParameterValues("users");
        List<Object> users = CollectionUtils.isArrayEmptyOrNull(usersArray) ? null : Arrays.asList(usersArray);
        Object[] ipAddressesArray = request.getParameterValues("ipAddresses");
        List<Object> ipAddresses = CollectionUtils.isArrayEmptyOrNull(ipAddressesArray) ? null : Arrays.asList(ipAddressesArray);
        String[] contentTypesArray = request.getParameterValues("contentTypes");
        ImmutableList<String> contentTypes = RecordCriteria.toUpperCase(contentTypesArray);
        Object[] contentIdsArray = request.getParameterValues("contentIds");
        List<Object> contentIds = CollectionUtils.isArrayEmptyOrNull(contentIdsArray) ? null : Arrays.asList(contentIdsArray);
        String[] actionsArray = request.getParameterValues("actions");
        ImmutableList<String> actions = RecordCriteria.toUpperCase(actionsArray);
        return RecordCriteria.create(query, users, fromTime, toTime, ipAddresses, contentTypes, contentIds, actions);
    }
}

