/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.jakarta;

import com.atlassian.sal.api.web.context.HttpContext;
import com.enhancera.accesslog.common.servlet.GenericHttpRequest;
import com.enhancera.accesslog.common.servlet.IpResolver;
import com.enhancera.accesslog.jakarta.JakartaHttpRequestAdapter;
import com.enhancera.accesslog.jakarta.util.JakartaRequestUtils;
import jakarta.servlet.http.HttpServletRequest;

public class JakartaIpResolver
implements IpResolver {
    public static final String DEFAULT_IP_VALUE = "-";
    private final HttpContext httpContext;

    public JakartaIpResolver(HttpContext httpContext) {
        this.httpContext = httpContext;
    }

    @Override
    public GenericHttpRequest getCurrentRequest() {
        return new JakartaHttpRequestAdapter(this.httpContext.getRequest());
    }

    @Override
    public String getCurrentIp() {
        HttpServletRequest request = this.httpContext.getRequest();
        return JakartaRequestUtils.extractIpAddress(request).orElse(DEFAULT_IP_VALUE);
    }

    @Override
    public String extractIpAddress(GenericHttpRequest request) {
        if (!(request instanceof JakartaHttpRequestAdapter)) {
            return DEFAULT_IP_VALUE;
        }
        JakartaHttpRequestAdapter jakartaHttpRequest = (JakartaHttpRequestAdapter)request;
        return JakartaRequestUtils.extractIpAddress(jakartaHttpRequest.getDelegate()).orElse(DEFAULT_IP_VALUE);
    }
}

