/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.confluence.util;

import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.user.EntityException;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.search.query.Query;
import com.atlassian.user.search.query.UserNameTermQuery;
import com.enhancera.accesslog.common.DataOption;
import com.enhancera.accesslog.common.util.FormattingLogger;
import com.enhancera.accesslog.common.util.UserSearchUtils;
import com.enhancera.accesslog.common.util.UserUtils;
import java.util.ArrayList;
import java.util.List;

public class ConfluenceUserSearchUtils
implements UserSearchUtils {
    private static final FormattingLogger log = FormattingLogger.getLogger(ConfluenceUserSearchUtils.class);
    private final UserUtils userUtils;
    private final UserAccessor userAccessor;

    public ConfluenceUserSearchUtils(UserUtils userUtils, UserAccessor userAccessor) {
        this.userUtils = userUtils;
        this.userAccessor = userAccessor;
    }

    @Override
    public List<DataOption> findUsers(String usernameSubstr, int maxResults) {
        ArrayList<DataOption> result = new ArrayList<DataOption>();
        try {
            Pager pager = this.userAccessor.findUsers((Query)new UserNameTermQuery(usernameSubstr, "contains")).pager();
            for (int i = 0; i < maxResults && pager.spliterator().tryAdvance(user -> result.add(DataOption.create(this.userUtils.getUserKeyValueByName(user.getName()), user.getName()))); ++i) {
            }
        }
        catch (EntityException e) {
            log.error(e, "Error while searching for users.", new Object[0]);
        }
        return result;
    }
}

