/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.confluence.recordparser.rest;

import com.enhancera.accesslog.common.AccessRecord;
import com.enhancera.accesslog.common.RequestData;
import com.enhancera.accesslog.common.ResponseData;
import com.enhancera.accesslog.common.recordparser.RecordParserUtils;
import com.enhancera.accesslog.common.util.RequestUtils;
import com.enhancera.accesslog.confluence.recordparser.rest.RestUriMatchingParser;
import com.enhancera.accesslog.confluence.util.ConfluenceApiContentRecordsParserUtils;
import com.enhancera.accesslog.confluence.util.ConfluenceContentUtils;
import com.enhancera.accesslog.confluence.util.ConfluenceRecordsParserUtils;
import com.enhancera.accesslog.confluence.util.ConfluenceUriRegexp;
import com.google.common.collect.ImmutableList;

public class GetMacroBodyRestViewRecordParser
extends RestUriMatchingParser {
    private static final String PARAM_MACRO_ID = "macroId";
    private final ConfluenceContentUtils contentUtils;

    public GetMacroBodyRestViewRecordParser(ConfluenceContentUtils contentUtils) {
        super(ConfluenceUriRegexp.RecordParserUriRegexp.REGEXP_REST_MACRO_BODY_VIEW_URI, false);
        this.contentUtils = contentUtils;
    }

    @Override
    protected ImmutableList<AccessRecord> parse(RequestData requestData, ResponseData responseData) {
        ConfluenceApiContentRecordsParserUtils.addUserToThreadLocal(requestData.getUserKey());
        return this.parseRestViewContentByIdRecords(requestData);
    }

    ImmutableList<AccessRecord> parseRestViewContentByIdRecords(RequestData requestData) {
        long contentId = RecordParserUtils.parseOptionalValue("contentId", RequestUtils.parseUriParamLong(requestData.getContextPath().concat(ConfluenceUriRegexp.RecordParserUriRegexp.REGEXP_REST_MACRO_BODY_VIEW_URI), requestData.getUri(), "contentId"));
        int version = Integer.parseInt(RecordParserUtils.parseOptionalValue("version", RequestUtils.parseUriParam(requestData.getContextPath().concat(ConfluenceUriRegexp.RecordParserUriRegexp.REGEXP_REST_MACRO_BODY_VIEW_URI), requestData.getUri(), "version")));
        String macroId = RecordParserUtils.parseOptionalValue(PARAM_MACRO_ID, RequestUtils.parseUriParam(requestData.getContextPath().concat(ConfluenceUriRegexp.RecordParserUriRegexp.REGEXP_REST_MACRO_BODY_VIEW_URI), requestData.getUri(), PARAM_MACRO_ID));
        return ConfluenceRecordsParserUtils.parseViewMacroRecords(requestData.getUserKey(), requestData.getIpAddress(), this.contentUtils.getContentByIdAndVersion(contentId, version).orElse(null), macroId, this.contentUtils.getMacroBody(contentId, version, macroId).orElse(null));
    }
}

