/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.confluence.recordparser.rest;

import com.enhancera.accesslog.common.AccessRecord;
import com.enhancera.accesslog.common.Action;
import com.enhancera.accesslog.common.RequestData;
import com.enhancera.accesslog.common.ResponseData;
import com.enhancera.accesslog.common.recordparser.RecordParserUtils;
import com.enhancera.accesslog.common.util.RequestUtils;
import com.enhancera.accesslog.confluence.recordparser.rest.RestUriMatchingParser;
import com.enhancera.accesslog.confluence.util.ConfluenceContentUtils;
import com.enhancera.accesslog.confluence.util.ConfluenceRecordsParserUtils;
import com.enhancera.accesslog.confluence.util.ConfluenceUriRegexp;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.commons.lang3.math.NumberUtils;

public class ContentByIdRestViewRecordParser
extends RestUriMatchingParser {
    private final ConfluenceContentUtils contentUtils;

    public ContentByIdRestViewRecordParser(ConfluenceContentUtils contentUtils) {
        super(ConfluenceUriRegexp.RecordParserUriRegexp.REGEXP_REST_CONTENT_VIEW_URI, true);
        this.contentUtils = contentUtils;
    }

    @Override
    protected ImmutableList<AccessRecord> parse(RequestData requestData, ResponseData responseData) {
        return this.parseRestViewContentByIdRecords(requestData);
    }

    ImmutableList<AccessRecord> parseRestViewContentByIdRecords(RequestData requestData) {
        Long contentId = RecordParserUtils.parseOptionalValue("contentId", RequestUtils.parseUriParamLong(requestData.getContextPath().concat(ConfluenceUriRegexp.RecordParserUriRegexp.REGEXP_REST_CONTENT_VIEW_URI), requestData.getUri(), "contentId"));
        List<String> statuses = requestData.getRequestParameterValues("status");
        String version = requestData.getRequestParameterValue("version").orElse(null);
        int intVersion = NumberUtils.toInt(version);
        return ConfluenceRecordsParserUtils.parseContentAccessRecords(requestData.getUserKey(), requestData.getIpAddress(), this.contentUtils.getContentById(contentId, ConfluenceRecordsParserUtils.parseContentStatusesContentById(statuses, intVersion), intVersion).orElse(null), Action.VIEW);
    }
}

