/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.confluence.recordparser.rest;

import com.atlassian.confluence.api.model.Depth;
import com.enhancera.accesslog.common.AccessRecord;
import com.enhancera.accesslog.common.RequestData;
import com.enhancera.accesslog.common.ResponseData;
import com.enhancera.accesslog.common.recordparser.RecordParserUtils;
import com.enhancera.accesslog.common.util.RequestUtils;
import com.enhancera.accesslog.confluence.recordparser.rest.BulkRestUriMatchingParser;
import com.enhancera.accesslog.confluence.util.ConfluenceApiContentRecordsParserUtils;
import com.enhancera.accesslog.confluence.util.ConfluenceContentUtils;
import com.enhancera.accesslog.confluence.util.ConfluenceUriRegexp;
import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import org.apache.commons.lang3.math.NumberUtils;

public class CommentsOfContentRestViewRecordParser
extends BulkRestUriMatchingParser {
    private static final String PARAM_LOCATION = "location";
    private final ConfluenceApiContentRecordsParserUtils apiContentRecordsParserUtils;
    private final ConfluenceContentUtils contentUtils;

    public CommentsOfContentRestViewRecordParser(ConfluenceApiContentRecordsParserUtils apiContentRecordsParserUtils, ConfluenceContentUtils contentUtils) {
        super(ConfluenceUriRegexp.RecordParserUriRegexp.REGEXP_REST_COMMENTS_OF_CONTENT_URI);
        this.apiContentRecordsParserUtils = apiContentRecordsParserUtils;
        this.contentUtils = contentUtils;
    }

    @Override
    protected ImmutableList<AccessRecord> parse(RequestData requestData, ResponseData responseData) {
        ConfluenceApiContentRecordsParserUtils.addUserToThreadLocal(requestData.getUserKey());
        return this.parseRestGetContentRecords(requestData);
    }

    ImmutableList<AccessRecord> parseRestGetContentRecords(RequestData requestData) {
        Long contentId = RecordParserUtils.parseOptionalValue("contentId", RequestUtils.parseUriParamLong(requestData.getContextPath().concat(ConfluenceUriRegexp.RecordParserUriRegexp.REGEXP_REST_COMMENTS_OF_CONTENT_URI), requestData.getUri(), "contentId"));
        String parentVersion = requestData.getRequestParameterValue("parentVersion").orElse(null);
        HashSet<String> locations = new HashSet<String>(requestData.getRequestParameterValues(PARAM_LOCATION));
        String depth = requestData.getRequestParameterValue("depth").orElse(null);
        String start = requestData.getRequestParameterValue("start").orElse(null);
        String limit = requestData.getRequestParameterValue("limit").orElse(null);
        return this.apiContentRecordsParserUtils.parseCommentsAccessRecords(contentId, this.contentUtils.getCommentsOfContent(contentId, NumberUtils.toInt(parentVersion), locations, CommentsOfContentRestViewRecordParser.createDepth(depth), NumberUtils.toInt(start), NumberUtils.toInt(limit, 25)), requestData);
    }

    private static Depth createDepth(String depthStr) {
        Depth depth = Depth.ROOT;
        if (Depth.ALL.toString().equals(depthStr)) {
            depth = Depth.ALL;
        }
        return depth;
    }
}

