/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.confluence.recordparser.rest;

import com.enhancera.accesslog.common.AccessRecord;
import com.enhancera.accesslog.common.RequestData;
import com.enhancera.accesslog.common.ResponseData;
import com.enhancera.accesslog.confluence.recordparser.rest.RestUriMatchingParser;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import org.apache.commons.lang3.math.NumberUtils;

public abstract class BulkRestUriMatchingParser
extends RestUriMatchingParser {
    public BulkRestUriMatchingParser(String uriRegexp) {
        super(uriRegexp, true);
    }

    @Override
    public ImmutableList<AccessRecord> parseRecords(RequestData requestData, ResponseData responseData) {
        String limit;
        ImmutableList<AccessRecord> result = ImmutableList.of();
        String start = requestData.getRequestParameterValue("start").orElse(null);
        if (BulkRestUriMatchingParser.isStartAndLimitValid(start, limit = (String)requestData.getRequestParameterValue("limit").orElse(null))) {
            result = super.parseRecords(requestData, responseData);
        }
        return result;
    }

    private static boolean isStartAndLimitValid(String start, String limit) {
        return BulkRestUriMatchingParser.isStartOrLimitValid(start) && BulkRestUriMatchingParser.isStartOrLimitValid(limit);
    }

    private static boolean isStartOrLimitValid(String value) {
        return Strings.isNullOrEmpty(value) || NumberUtils.toInt(value, -1) >= 0;
    }
}

