/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.confluence.recordparser;

import com.enhancera.accesslog.common.AccessRecord;
import com.enhancera.accesslog.common.RequestData;
import com.enhancera.accesslog.common.ResponseData;
import com.enhancera.accesslog.common.recordparser.RecordParserUtils;
import com.enhancera.accesslog.common.recordparser.UriMatchingParserWithSpecifiedMethods;
import com.enhancera.accesslog.common.rest.HttpMethod;
import com.enhancera.accesslog.confluence.util.ConfluenceContentUtils;
import com.enhancera.accesslog.confluence.util.ConfluenceUriRegexp;
import com.enhancera.accesslog.confluence.util.ConfluenceWebRecordsParserUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;

public class SpaceExportRecordsParser
extends UriMatchingParserWithSpecifiedMethods {
    private static final String SPACE_KEY_PARAM = "key";
    private final ConfluenceContentUtils contentUtils;
    private final ConfluenceWebRecordsParserUtils confluenceWebRecordsParserUtils;

    public SpaceExportRecordsParser(ConfluenceContentUtils contentUtils, ConfluenceWebRecordsParserUtils confluenceWebRecordsParserUtils) {
        super(ConfluenceUriRegexp.RecordParserUriRegexp.REGEXP_SPACE_EXPORT, ImmutableSet.of(HttpMethod.POST));
        this.contentUtils = contentUtils;
        this.confluenceWebRecordsParserUtils = confluenceWebRecordsParserUtils;
    }

    @Override
    protected ImmutableList<AccessRecord> parse(RequestData requestData, ResponseData responseData) {
        String spaceKey = RecordParserUtils.parseOptionalValue("space key", requestData.getRequestParameterValue(SPACE_KEY_PARAM));
        return this.confluenceWebRecordsParserUtils.parseExportSpaceRecord(requestData.getUserKey(), requestData.getIpAddress(), this.contentUtils.getSpace(spaceKey).orElse(null));
    }
}

