/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.common.util;

import com.enhancera.accesslog.common.util.FormattingLogger;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;

public class JsonUtils {
    private static final FormattingLogger log = FormattingLogger.getLogger(JsonUtils.class);
    private static final Gson GSON = new Gson();

    public static <T> String toJson(T object, Class<T> type) {
        return GSON.toJson(object, type);
    }

    public static <T> T parse(String json, Class<T> type) {
        try {
            return GSON.fromJson(json, type);
        }
        catch (JsonSyntaxException e) {
            log.error(e, "Error while parsing JSON.", new Object[0]);
            return null;
        }
    }

    private JsonUtils() {
    }
}

