/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.common.util;

import com.atlassian.activeobjects.spi.DatabaseType;
import com.enhancera.accesslog.common.ao.ActiveObjectsComponent;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;

public class DatabaseUtils {
    private static final EnumSet<DatabaseType> COLUMN_ESCAPE_DB_LIST = EnumSet.of(DatabaseType.POSTGRESQL, DatabaseType.HSQL);
    private final ActiveObjectsComponent ao;

    public DatabaseUtils(ActiveObjectsComponent ao) {
        this.ao = ao;
    }

    public boolean isDbRequiresColumnEscaping() {
        return COLUMN_ESCAPE_DB_LIST.contains(this.ao.moduleMetaData().getDatabaseType());
    }

    public static Set<String> toUpperCase(Collection<String> data) {
        return data.stream().map(String::toUpperCase).collect(Collectors.toSet());
    }

    public static String joinValues(Collection<String> data) {
        return String.join((CharSequence)"', '", data);
    }
}

