/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.common.rest;

import com.enhancera.accesslog.common.DataOptionType;
import com.enhancera.accesslog.common.DataOptionsProvider;
import com.enhancera.accesslog.common.rest.ServiceResponse;
import com.enhancera.accesslog.common.util.FormattingLogger;
import com.enhancera.accesslog.common.util.UserUtils;

public class FilterDataResourceExecutor {
    private static final FormattingLogger log = FormattingLogger.getLogger(FilterDataResourceExecutor.class);
    private final DataOptionsProvider dataOptionsProvider;
    private final UserUtils userUtils;

    public FilterDataResourceExecutor(DataOptionsProvider dataOptionsProvider, UserUtils userUtils) {
        this.dataOptionsProvider = dataOptionsProvider;
        this.userUtils = userUtils;
    }

    public ServiceResponse getObjectOptions(DataOptionType option, String param) {
        if (!this.userUtils.isAdmin()) {
            log.error("User %s is not authorized to view audit trail.", this.userUtils.getRemoteUserKey());
            return ServiceResponse.serverError().status(403).build();
        }
        return ServiceResponse.ok(this.dataOptionsProvider.findDataOptions(option, param, false)).build();
    }
}

