/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.common.recordparser;

import com.enhancera.accesslog.common.util.FormattingLogger;
import com.enhancera.accesslog.common.util.FormattingUtils;
import com.google.common.collect.ImmutableList;
import java.util.Optional;
import org.joda.time.DateTime;

public class RecordParserUtils {
    public static final String XAUSERNAME_RESPONSE_HEADER_NAME = "X-AUSERNAME";
    public static final String OS_USERNAME_REQUEST_PARAM_NAME = "os_username";
    private static final String CONFLUENCE_DO_AUTHENTICATE_ACTION_URL = "/doauthenticate.action";
    private static final String CONFLUENCE_DROP_ADMIN_ACCESS_ACTION_URL = "/(ajax/)?dropauthentication.action";
    public static final ImmutableList<String> CONFLUENCE_XAUSERNAME_HEADER_NEEDED_IN_PARSER_URLS = ImmutableList.of("/doauthenticate.action", "/(ajax/)?dropauthentication.action");
    private static final FormattingLogger log = FormattingLogger.getLogger(RecordParserUtils.class);
    public static final String CONTENT_TYPE = "contentType";
    public static final String CONTENT_ID = "contentId";
    public static final String NEW_CONTENT_DISPLAY_NAME = "contentDisplayName";
    public static final String IP_ADDRESS = "ipAddress";
    public static final String ERROR_NULL_FIELD_VALUE_PATTERN = "%s is null";
    public static final String ERROR_NO_HANDLER_FOUND_PATTERN = "No handler for field: %, value: %s found.";
    public static final String UNKNOWN_IP_ADDRESS = "-";
    public static final String UNKNOWN_VALUE = "<unknown>";
    public static final String UNKNOWN_USER = "<unknown>";
    public static final String UNKNOWN = "unknown";
    public static final String FOCUSED_COMMENT_ID = "focusedCommentId";

    public static <T> T parseOptionalValue(String fieldName, Optional<T> optionalValue) {
        if (optionalValue.isPresent()) {
            return optionalValue.get();
        }
        log.error(ERROR_NULL_FIELD_VALUE_PATTERN, fieldName);
        return null;
    }

    public static String createCommentDisplayName(String contentKey, DateTime commentCreatedTime) {
        return RecordParserUtils.createContentDisplayNameWithAuxiliaryParam(contentKey, FormattingUtils.formatTime(commentCreatedTime));
    }

    public static String createContentDisplayNameWithAuxiliaryParam(String contentKey, String auxiliaryParam) {
        return String.valueOf(contentKey).concat(" (").concat(auxiliaryParam).concat(")");
    }

    private RecordParserUtils() {
    }
}

