/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.common.logwriters;

import com.enhancera.accesslog.common.AccessRecord;
import com.enhancera.accesslog.common.database.DataLayer;
import com.enhancera.accesslog.common.logwriters.AccessLogWriter;
import com.enhancera.accesslog.common.util.FormattingLogger;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.Duration;

public class DatabaseAccessLogWriter
implements AccessLogWriter {
    private static final Duration CLEANUP_CHECK_PERIOD = Duration.standardHours(6L);
    private static final FormattingLogger log = FormattingLogger.getLogger(DatabaseAccessLogWriter.class);
    private final DataLayer dataLayer;
    private DateTime lastCleanupTime = new DateTime(0L);

    public DatabaseAccessLogWriter(DataLayer dataLayer) {
        this.dataLayer = dataLayer;
    }

    @Override
    public void write(List<AccessRecord> accessRecords) {
        log.debug("Writing records %s to database", accessRecords);
        this.dataLayer.writeRecords(accessRecords);
        DateTime now = DateTime.now();
        if (this.lastCleanupTime.isBefore(now.minus(CLEANUP_CHECK_PERIOD))) {
            this.lastCleanupTime = now;
            this.dataLayer.deleteOldRecords();
        }
    }
}

