/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.common.database;

import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.enhancera.accesslog.common.AccessRecord;
import com.enhancera.accesslog.common.ContentType;
import com.enhancera.accesslog.common.DataOption;
import com.enhancera.accesslog.common.PagedAccessRecords;
import com.enhancera.accesslog.common.RecordCriteria;
import com.enhancera.accesslog.common.ao.AccessRecordEntity;
import com.enhancera.accesslog.common.ao.ActiveObjectsComponent;
import com.enhancera.accesslog.common.config.ConfigService;
import com.enhancera.accesslog.common.data.SortParams;
import com.enhancera.accesslog.common.database.DataLayer;
import com.enhancera.accesslog.common.database.ProcessRecordCallback;
import com.enhancera.accesslog.common.rest.AccessRecordApi;
import com.enhancera.accesslog.common.util.ActionAndContentTypeToUiNameUtils;
import com.enhancera.accesslog.common.util.DatabaseUtils;
import com.enhancera.accesslog.common.util.FormattingLogger;
import com.enhancera.accesslog.common.util.RecordApiFactory;
import com.enhancera.accesslog.common.util.SearchableStringUtils;
import com.enhancera.accesslog.common.util.UserSearchUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.java.ao.Query;
import org.apache.commons.collections4.CollectionUtils;
import org.joda.time.DateTime;
import org.joda.time.Duration;

public class ActiveObjectsDataLayerImpl
implements DataLayer {
    private static final int THREAD_POOL_SIZE = 2;
    private static final FormattingLogger log = FormattingLogger.getLogger(ActiveObjectsDataLayerImpl.class);
    private final ActiveObjectsComponent ao;
    private final RecordApiFactory recordApiFactory;
    private final ConfigService configService;
    private final TransactionTemplate transactionTemplate;
    private final Executor executor = Executors.newFixedThreadPool(2);
    private final UserSearchUtils userSearchUtils;
    private final DatabaseUtils databaseUtils;
    private final ActionAndContentTypeToUiNameUtils actionAndContentTypeToUiNameUtils;
    private final SearchableStringUtils searchableStringUtils;

    public ActiveObjectsDataLayerImpl(ActiveObjectsComponent ao, RecordApiFactory recordApiFactory, ConfigService configService, TransactionTemplate transactionTemplate, UserSearchUtils userSearchUtils, DatabaseUtils databaseUtils, ActionAndContentTypeToUiNameUtils actionAndContentTypeToUiNameUtils) {
        this.ao = Preconditions.checkNotNull(ao);
        this.recordApiFactory = recordApiFactory;
        this.configService = configService;
        this.transactionTemplate = transactionTemplate;
        this.userSearchUtils = userSearchUtils;
        this.databaseUtils = databaseUtils;
        this.actionAndContentTypeToUiNameUtils = actionAndContentTypeToUiNameUtils;
        this.searchableStringUtils = new SearchableStringUtils(actionAndContentTypeToUiNameUtils);
    }

    @Override
    public void writeRecords(List<AccessRecord> accessRecords) {
        for (AccessRecord accessRecord : accessRecords) {
            this.writeRecord(accessRecord);
        }
    }

    private void writeRecord(AccessRecord accessRecord) {
        HashMap<String, Object> accessRecordParams = Maps.newHashMap();
        accessRecordParams.put("TIME", accessRecord.getTime().getMillis());
        accessRecordParams.put("USER", accessRecord.getUser());
        accessRecordParams.put("IP_ADDRESS", accessRecord.getIpAddress());
        accessRecordParams.put("CONTENT_TYPE", accessRecord.getContentType().getName());
        accessRecordParams.put("CONTENT_ID", accessRecord.getContentId());
        accessRecordParams.put("NEW_CONTENT_DISPLAY_NAME", accessRecord.getContentDisplayName());
        accessRecordParams.put("ACTION", accessRecord.getAction().name());
        accessRecordParams.put("SEARCHABLE_STRING", this.searchableStringUtils.createSearchableString(accessRecord));
        accessRecordParams.put("URL_PATH", accessRecord.getUrlPath());
        AccessRecordEntity accessRecordEntity = this.ao.create(AccessRecordEntity.class, accessRecordParams);
        log.debug("Saved entity: %s", accessRecordEntity);
    }

    @Override
    public void readRecords(RecordCriteria criteria, SortParams sortParams, ProcessRecordCallback callback) {
        this.ao.stream(AccessRecordEntity.class, this.filter(Query.select((String)"ID, TIME, USER, IP_ADDRESS, CONTENT_TYPE, CONTENT_ID, NEW_CONTENT_DISPLAY_NAME, ACTION").order(sortParams.toString()), criteria), entity -> this.recordApiFactory.getRecordApi((AccessRecordEntity)entity).ifPresent(callback::valueRead));
    }

    @Override
    public PagedAccessRecords readPagedRecords(RecordCriteria criteria, int pageNumber, SortParams sortParams, int numberOfResultsPerPage) {
        Query query = this.filter(Query.select(), criteria);
        int totalAccessRecordsCount = this.ao.count(AccessRecordEntity.class, query);
        int calculatedPageNumber = ActiveObjectsDataLayerImpl.calculatePageNumber(pageNumber, (int)Math.ceil((double)totalAccessRecordsCount / (double)numberOfResultsPerPage));
        int startIndex = (calculatedPageNumber - 1) * numberOfResultsPerPage;
        query = this.filter(this.createPagedQuery(startIndex, numberOfResultsPerPage), criteria);
        List<AccessRecordApi> accessRecordsApi = this.convertFromEntityToApi((AccessRecordEntity[])this.ao.find(AccessRecordEntity.class, query.order(sortParams.toString()).limit(numberOfResultsPerPage).offset(startIndex)));
        return new PagedAccessRecords(accessRecordsApi, startIndex, calculatedPageNumber, numberOfResultsPerPage, totalAccessRecordsCount);
    }

    @VisibleForTesting
    public Query filter(Query query, RecordCriteria criteria) {
        ArrayList<Object> queryParams = new ArrayList<Object>();
        if (criteria.isEmpty()) {
            return query;
        }
        StringBuilder builder = new StringBuilder("1=1");
        if (criteria.getInterval() != null) {
            builder.append(" AND TIME BETWEEN ? AND ?");
            queryParams.add(criteria.getInterval().getStartMillis());
            queryParams.add(criteria.getInterval().getEndMillis());
        }
        if (!CollectionUtils.isEmpty(criteria.getUsers())) {
            builder.append(" AND (".concat(this.getUserQuery(criteria.getUsers(), queryParams)).concat(")"));
        }
        if (!CollectionUtils.isEmpty(criteria.getIpAddresses())) {
            builder.append(" AND (".concat(this.getIpAddressQuery(criteria.getIpAddresses(), queryParams)).concat(")"));
        }
        if (!CollectionUtils.isEmpty(criteria.getContentTypes())) {
            builder.append(this.createQueryPart("CONTENT_TYPE", criteria.getContentTypes(), queryParams));
        }
        if (!CollectionUtils.isEmpty(criteria.getContentIds())) {
            builder.append(String.format(this.databaseUtils.isDbRequiresColumnEscaping() ? " AND UPPER(\"NEW_CONTENT_DISPLAY_NAME\") IN (%s)" : " AND UPPER(NEW_CONTENT_DISPLAY_NAME) IN (%s)", ActiveObjectsDataLayerImpl.preparePlaceHolders(criteria.getContentIds().size())));
            queryParams.addAll(DatabaseUtils.toUpperCase(criteria.getContentIds()));
        }
        if (!CollectionUtils.isEmpty(criteria.getActions())) {
            builder.append(this.createQueryPart("ACTION", criteria.getActions(), queryParams));
        }
        builder.append(this.getUserQueryForSearch(criteria.getSearchQuery(), queryParams));
        return query.where(builder.toString(), queryParams.toArray());
    }

    public static String preparePlaceHolders(int length) {
        return String.join((CharSequence)",", Collections.nCopies(length, "?"));
    }

    private String getUserQueryForSearch(String searchQuery, List<Object> queryParams) {
        String result = "";
        if (!Strings.isNullOrEmpty(searchQuery)) {
            List<String> users = this.userSearchUtils.findUsers(searchQuery.toLowerCase(), 100).stream().map(DataOption::getId).collect(Collectors.toList());
            if ("<unknown>".toUpperCase().contains(searchQuery.toUpperCase())) {
                users.add("<unknown>");
            }
            String likeExpression = "%" + searchQuery.toLowerCase() + "%";
            queryParams.add(likeExpression);
            String userQuery = this.getUserQuery(users, queryParams);
            if (!userQuery.isEmpty()) {
                userQuery = "OR " + userQuery;
            }
            String contentTypeQueryForSearch = this.getContentTypeQueryForSearch(searchQuery, queryParams);
            String actionQueryForSearch = this.getActionQueryForSearch(searchQuery, queryParams);
            result = " AND (SEARCHABLE_STRING LIKE ? " + userQuery + contentTypeQueryForSearch + actionQueryForSearch + ")";
        }
        return result;
    }

    private String getContentTypeQueryForSearch(String searchQuery, List<Object> queryParams) {
        String result = "";
        if (Strings.isNullOrEmpty(searchQuery)) {
            return result;
        }
        List contentTypes = this.actionAndContentTypeToUiNameUtils.getContentTypesByUiTextSubstringIgnoreCase(searchQuery).stream().map(ContentType::getName).collect(Collectors.toList());
        if (contentTypes.isEmpty()) {
            return result;
        }
        queryParams.addAll(contentTypes);
        return String.format(" OR CONTENT_TYPE IN (%s)", ActiveObjectsDataLayerImpl.preparePlaceHolders(contentTypes.size()));
    }

    private String getActionQueryForSearch(String searchQuery, List<Object> queryParams) {
        String result = "";
        if (Strings.isNullOrEmpty(searchQuery)) {
            return result;
        }
        List actions = this.actionAndContentTypeToUiNameUtils.getActionsByUiTextSubstringIgnoreCase(searchQuery).stream().map(Enum::name).collect(Collectors.toList());
        if (actions.isEmpty()) {
            return result;
        }
        queryParams.addAll(actions);
        return String.format(" OR ACTION IN (%s)", ActiveObjectsDataLayerImpl.preparePlaceHolders(actions.size()));
    }

    private String getUserQuery(Collection<String> users, List<Object> queryParams) {
        ArrayList<String> usersTemp = new ArrayList<String>(users);
        String result = "";
        String unknkownUserQueryPart = "";
        if (usersTemp.stream().anyMatch("<unknown>"::equals)) {
            unknkownUserQueryPart = " OR USER IS NULL";
            usersTemp.remove("<unknown>");
        }
        if (!usersTemp.isEmpty()) {
            result = String.format("USER IN (%s)%s", ActiveObjectsDataLayerImpl.preparePlaceHolders(usersTemp.size()), unknkownUserQueryPart);
            queryParams.addAll(usersTemp);
        } else if (!unknkownUserQueryPart.isEmpty()) {
            result = "USER IS NULL";
        }
        return result;
    }

    private String getIpAddressQuery(Collection<String> ipAddresses, List<Object> queryParams) {
        ArrayList<String> ipAddressesTemp = new ArrayList<String>(ipAddresses);
        String result = "";
        String unknownIpAddressQueryPart = "";
        if (ipAddressesTemp.stream().anyMatch("-"::equals)) {
            unknownIpAddressQueryPart = " OR IP_ADDRESS IS NULL";
        }
        if (!ipAddressesTemp.isEmpty()) {
            result = String.format("IP_ADDRESS IN (%s)%s", ActiveObjectsDataLayerImpl.preparePlaceHolders(ipAddressesTemp.size()), unknownIpAddressQueryPart);
            queryParams.addAll(ipAddressesTemp);
        } else if (!unknownIpAddressQueryPart.isEmpty()) {
            result = "IP_ADDRESS IS NULL";
        }
        return result;
    }

    private String createQueryPart(String columnName, Collection<String> valuesToSearchFor, List<Object> queryParams) {
        queryParams.addAll(valuesToSearchFor);
        return String.format(" AND " + columnName + " IN (%s)", ActiveObjectsDataLayerImpl.preparePlaceHolders(valuesToSearchFor.size()));
    }

    private Query createPagedQuery(int startIndex, int numberOfResultsPerPage) {
        return Query.select().order("TIME DESC").limit(numberOfResultsPerPage).offset(startIndex);
    }

    private static int calculatePageNumber(int pageNumber, int totalPagesCount) {
        int result = PagedAccessRecords.START_PAGE;
        if (pageNumber > PagedAccessRecords.START_PAGE) {
            int lastPage = totalPagesCount > 0 ? totalPagesCount : PagedAccessRecords.START_PAGE;
            result = pageNumber <= lastPage ? pageNumber : lastPage;
        }
        return result;
    }

    private List<AccessRecordApi> convertFromEntityToApi(AccessRecordEntity ... entities) {
        return Stream.of(entities).map(this.recordApiFactory::getRecordApi).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    @Override
    public void deleteOldRecords() {
        int retentionPeriod = this.configService.getConfig().getRetentionPeriod();
        if (retentionPeriod > 0) {
            this.executor.execute(() -> {
                Integer entitiesNumber = (Integer)this.transactionTemplate.execute(() -> this.ao.deleteWithSQL(AccessRecordEntity.class, "TIME < ?", DateTime.now().minus(Duration.standardDays(retentionPeriod)).getMillis()));
                log.info("%d record entities are deleted", entitiesNumber);
            });
        }
    }

    @Override
    public void deleteAllRecords(Runnable writeDeleteAllRecordsAccessRecord) {
        log.info("Deleting all records from the database", new Object[0]);
        this.executor.execute(() -> {
            Integer entitiesNumber = (Integer)this.transactionTemplate.execute(() -> {
                int deletedEntitiesCount = this.ao.deleteWithSQL(AccessRecordEntity.class, "ID > 0", new Object[0]);
                writeDeleteAllRecordsAccessRecord.run();
                return deletedEntitiesCount;
            });
            log.info("All %d record entities are deleted", entitiesNumber);
        });
    }
}

