/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.common.config;

import com.cloudbees.syslog.Facility;
import com.cloudbees.syslog.Severity;
import com.enhancera.accesslog.common.config.Config;
import com.enhancera.accesslog.common.config.ConfigDao;
import com.enhancera.accesslog.common.config.FieldsService;
import com.enhancera.accesslog.common.eventsconfig.DefaultEventsConfigProvider;
import com.google.common.collect.ImmutableMap;

public class ConfigService {
    public static final ImmutableMap<Integer, Integer> OLD_TO_NEW_SEVERITY_MAP = ImmutableMap.builder().put(10000, Severity.DEBUG.numericalCode()).put(20000, Severity.INFORMATIONAL.numericalCode()).put(30000, Severity.WARNING.numericalCode()).put(40000, Severity.ERROR.numericalCode()).put(50000, Severity.EMERGENCY.numericalCode()).build();
    private static final ImmutableMap<Integer, Integer> OLD_TO_NEW_FACILITY_MAP = ImmutableMap.builder().put(0, Facility.KERN.numericalCode()).put(8, Facility.USER.numericalCode()).put(16, Facility.MAIL.numericalCode()).put(24, Facility.DAEMON.numericalCode()).put(32, Facility.AUTH.numericalCode()).put(40, Facility.SYSLOG.numericalCode()).put(48, Facility.LPR.numericalCode()).put(56, Facility.NEWS.numericalCode()).put(64, Facility.UUCP.numericalCode()).put(72, Facility.CRON.numericalCode()).put(80, Facility.AUTHPRIV.numericalCode()).put(88, Facility.FTP.numericalCode()).put(128, Facility.LOCAL0.numericalCode()).put(136, Facility.LOCAL1.numericalCode()).put(144, Facility.LOCAL2.numericalCode()).put(152, Facility.LOCAL3.numericalCode()).put(160, Facility.LOCAL4.numericalCode()).put(168, Facility.LOCAL5.numericalCode()).put(176, Facility.LOCAL6.numericalCode()).put(184, Facility.LOCAL7.numericalCode()).build();
    private final ConfigDao dao;
    private final DefaultEventsConfigProvider eventsConfigProvider;
    private final FieldsService fieldsService;

    public ConfigService(ConfigDao dao, DefaultEventsConfigProvider eventsConfigProvider, FieldsService fieldsService) {
        this.dao = dao;
        this.eventsConfigProvider = eventsConfigProvider;
        this.fieldsService = fieldsService;
    }

    public Config getConfig() {
        int syslogLevel;
        Config config = this.dao.load();
        if (config == null) {
            config = new Config(this.fieldsService.getDefaultSensitiveFields());
            this.dao.save(config);
        }
        if (config.getEnabledContentTypeActions() == null) {
            config.setEnabledContentTypeActions(this.eventsConfigProvider.createDefaultContentTypeActionsMap());
            this.dao.save(config);
        }
        if (config.getSensitiveFields() == null) {
            config.setSensitiveFields(this.fieldsService.getDefaultSensitiveFields());
            this.dao.save(config);
        }
        if (OLD_TO_NEW_SEVERITY_MAP.containsKey(syslogLevel = config.getSyslogLevel())) {
            config.setSyslogLevel(OLD_TO_NEW_SEVERITY_MAP.get(syslogLevel));
            int syslogFacility = config.getSyslogFacility();
            if (OLD_TO_NEW_FACILITY_MAP.containsKey(syslogFacility)) {
                config.setSyslogFacility(OLD_TO_NEW_FACILITY_MAP.get(syslogFacility));
            }
            this.dao.save(config);
        }
        return config;
    }

    public void setConfig(Config config) {
        this.dao.save(config);
    }
}

