/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.common.ao.upgrade.v2;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.enhancera.accesslog.common.ao.AccessRecordEntity;
import com.enhancera.accesslog.common.ao.upgrade.UpgradeTask;
import com.enhancera.accesslog.common.util.FormattingLogger;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.DoubleConsumer;
import net.java.ao.Query;
import net.java.ao.RawEntity;

public class ContentDisplayNameLengthMigrationTask
implements UpgradeTask {
    private static final FormattingLogger log = FormattingLogger.getLogger(ContentDisplayNameLengthMigrationTask.class);
    private final ActiveObjects ao;
    private final TransactionTemplate transactionTemplate;

    public ContentDisplayNameLengthMigrationTask(ActiveObjects ao, TransactionTemplate transactionTemplate) {
        this.ao = ao;
        this.transactionTemplate = transactionTemplate;
    }

    @Override
    public void execute(DoubleConsumer progressTracker) {
        this.transactionTemplate.execute(() -> {
            this.ao.migrate(new Class[]{AccessRecordEntity.class});
            return null;
        });
        Query query = Query.select().where("NEW_CONTENT_DISPLAY_NAME IS NULL", new Object[0]).limit(999);
        int accessRecordCount = (Integer)this.transactionTemplate.execute(() -> this.ao.count(AccessRecordEntity.class, query));
        if (accessRecordCount == 0) {
            return;
        }
        AtomicInteger processed = new AtomicInteger();
        AtomicInteger recordEntitiesLength = new AtomicInteger();
        do {
            this.transactionTemplate.execute(() -> {
                AccessRecordEntity[] accessRecordEntities;
                for (AccessRecordEntity entity : accessRecordEntities = (AccessRecordEntity[])this.ao.find(AccessRecordEntity.class, query)) {
                    String contentDisplayName = entity.getContentDisplayName();
                    if (contentDisplayName == null) {
                        log.error("Access record entity %s is corrupted. ACCESS_RECORD_ENTITY table is invalid state. Access log plugin may not work properly.", entity);
                        this.ao.delete(new RawEntity[]{entity});
                    } else {
                        entity.setNewContentDisplayName(contentDisplayName);
                        entity.save();
                    }
                    processed.getAndIncrement();
                }
                recordEntitiesLength.set(accessRecordEntities.length);
                progressTracker.accept((double)processed.get() / (double)accessRecordCount);
                return null;
            });
        } while (recordEntitiesLength.get() == 999);
    }
}

