/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.common.ao.upgrade;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.enhancera.accesslog.common.ao.upgrade.UpgradeStatus;
import com.enhancera.accesslog.common.data.ActiveObjectsSettingsDao;
import com.enhancera.accesslog.common.data.SettingsDao;
import com.enhancera.accesslog.common.util.JsonUtils;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.DisposableBean;

public class UpgradeStatusDao
implements DisposableBean {
    private static final Logger log = Logger.getLogger(UpgradeStatusDao.class);
    private static final String SETTINGS_KEY = "upgrade-status";
    private final SettingsDao settingsDao;

    public UpgradeStatusDao(ActiveObjects ao, TransactionTemplate transactionTemplate) {
        this.settingsDao = new ActiveObjectsSettingsDao(ao, transactionTemplate);
    }

    public UpgradeStatus save(UpgradeStatus status) {
        if (status != null) {
            this.settingsDao.set(SETTINGS_KEY, JsonUtils.toJson(status, UpgradeStatus.class));
        } else {
            this.settingsDao.remove(SETTINGS_KEY);
        }
        return status;
    }

    @Nullable
    public UpgradeStatus load() {
        return JsonUtils.parse(this.settingsDao.get(SETTINGS_KEY), UpgradeStatus.class);
    }

    public void destroy() throws Exception {
        UpgradeStatus stored = this.load();
        if (stored != null) {
            UpgradeStatus stopped = new UpgradeStatus(stored.getQueued());
            this.save(stopped);
            log.debug((Object)"Upgrade task aborted.");
        }
    }
}

