/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.jakarta.responseparsers;

import com.enhancera.accesslog.common.util.FormattingLogger;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Locale;

public class ContentCapturingPrintWriter
extends PrintWriter {
    private static final FormattingLogger log = FormattingLogger.getLogger(ContentCapturingPrintWriter.class);
    private final PrintWriter servletPrintWriter;
    private final PrintWriter pw;
    private final StringWriter sw;

    public ContentCapturingPrintWriter(PrintWriter printWriter) {
        super(printWriter);
        this.servletPrintWriter = printWriter;
        this.sw = new StringWriter();
        this.pw = new PrintWriter(this.sw);
    }

    public String getContent() {
        this.pw.flush();
        return this.sw.toString();
    }

    @Override
    public void flush() {
        this.pw.flush();
        this.servletPrintWriter.flush();
    }

    @Override
    public void write(int i) {
        this.pw.write(i);
        this.servletPrintWriter.write(i);
    }

    @Override
    public void write(char[] buf, int off, int len) {
        this.servletPrintWriter.write(buf, off, len);
        this.pw.write(buf, off, len);
    }

    @Override
    public void write(char[] buf) {
        this.servletPrintWriter.write(buf);
        this.pw.write(buf);
    }

    @Override
    public void write(String s2, int off, int len) {
        this.servletPrintWriter.write(s2, off, len);
        this.pw.write(s2, off, len);
    }

    @Override
    public void write(String s2) {
        this.servletPrintWriter.write(s2);
        this.pw.write(s2);
    }

    @Override
    public void print(char c) {
        this.servletPrintWriter.print(c);
        this.pw.write(c);
    }

    @Override
    public void print(char[] s2) {
        this.servletPrintWriter.print(s2);
        this.pw.print(s2);
    }

    @Override
    public void print(String s2) {
        this.servletPrintWriter.print(s2);
        this.pw.print(s2);
    }

    @Override
    public void print(Object obj) {
        this.servletPrintWriter.print(obj);
        this.pw.print(obj);
    }

    @Override
    public void println() {
        this.servletPrintWriter.println();
        this.pw.println();
    }

    @Override
    public void println(char x) {
        this.servletPrintWriter.println(x);
        this.pw.println(x);
    }

    @Override
    public void println(char[] x) {
        this.servletPrintWriter.println(x);
    }

    @Override
    public void println(String x) {
        this.servletPrintWriter.println(x);
        this.pw.println(x);
    }

    @Override
    public void println(Object x) {
        this.servletPrintWriter.println(x);
        this.pw.println(x);
    }

    @Override
    public PrintWriter printf(String format, Object ... args) {
        this.servletPrintWriter.printf(format, args);
        this.pw.printf(format, args);
        return this;
    }

    @Override
    public PrintWriter printf(Locale l, String format, Object ... args) {
        this.servletPrintWriter.printf(l, format, args);
        this.pw.printf(l, format, args);
        return this;
    }

    @Override
    public PrintWriter format(String format, Object ... args) {
        this.servletPrintWriter.format(format, args);
        this.pw.format(format, args);
        return this;
    }

    @Override
    public PrintWriter format(Locale l, String format, Object ... args) {
        this.servletPrintWriter.format(l, format, args);
        this.pw.format(l, format, args);
        return this;
    }

    @Override
    public PrintWriter append(CharSequence csq) {
        this.servletPrintWriter.append(csq);
        this.pw.append(csq);
        return this;
    }

    @Override
    public PrintWriter append(CharSequence csq, int start, int end) {
        this.servletPrintWriter.append(csq, start, end);
        this.pw.append(csq, start, end);
        return this;
    }

    @Override
    public PrintWriter append(char c) {
        this.servletPrintWriter.append(c);
        this.pw.append(c);
        return this;
    }
}

