/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.confluence.util;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.CommentManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.enhancera.accesslog.common.CommonContentType;
import com.enhancera.accesslog.common.ContentType;
import com.enhancera.accesslog.common.util.ContentTypeService;
import com.enhancera.accesslog.common.util.FormattingLogger;
import com.enhancera.accesslog.common.util.NumberUtils;
import com.enhancera.accesslog.common.util.RequestUtils;
import com.enhancera.accesslog.confluence.ConfluenceContentType;
import com.google.common.collect.Sets;
import com.google.common.primitives.Longs;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class ConfluenceContentTypeService
implements ContentTypeService {
    private static final String DOWNLOAD_ATTACHMENT_URI_PART = "/download/attachments/";
    private static final String DISPLAY_URI_PART = "/display/";
    private static final String USER_DETAIL_URI = "/display/~";
    private static final String REGEXP_ATTACHMENT_CONTENT_ID = "(?<".concat("pageId").concat(">\\d+)\\|(?<").concat("attachment").concat(">\\d+)\\|(?<").concat("attachmentVer").concat(">\\d+)?(\\|(?<").concat("slide").concat(">\\d+))?");
    private static final FormattingLogger log = FormattingLogger.getLogger(ConfluenceContentTypeService.class);
    private final AttachmentManager attachmentManager;
    private final CommentManager commentManager;
    private final SpaceManager spaceManager;

    public ConfluenceContentTypeService(AttachmentManager attachmentManager, CommentManager commentManager, SpaceManager spaceManager) {
        this.attachmentManager = attachmentManager;
        this.commentManager = commentManager;
        this.spaceManager = spaceManager;
    }

    @Override
    public String createContentIdViewUri(ContentType contentType, String contentIdStr, String contentDisplayName) {
        String result = null;
        if (CommonContentType.USER_EVENT.equals(contentType)) {
            return ConfluenceContentTypeService.getUserDetailUri(contentDisplayName);
        }
        Long contentId = Longs.tryParse(contentIdStr);
        if (contentType instanceof ConfluenceContentType) {
            switch ((ConfluenceContentType)contentType) {
                case PAGE: 
                case BLOG_POST: {
                    result = ConfluenceContentTypeService.getPageUri(contentId);
                    break;
                }
                case SPACE: {
                    result = this.getSpaceUri(contentDisplayName, contentId);
                    break;
                }
                case MACRO: {
                    result = this.getMacroUri(contentIdStr);
                    break;
                }
                default: {
                    log.error("No handler for field: %, value: %s found.", "contentType", contentType);
                    break;
                }
            }
        } else {
            switch ((CommonContentType)contentType) {
                case ATTACHMENT: {
                    result = this.getAttachmentUri(contentIdStr, contentDisplayName);
                    break;
                }
                case COMMENT: {
                    result = this.getCommentUri(contentId);
                    break;
                }
                case ACCESS_LOG_PLUGIN_EVENT: {
                    result = "/plugins/servlet/accesslog/view";
                    break;
                }
                default: {
                    log.error("No handler for field: %, value: %s found.", "contentType", contentType);
                }
            }
        }
        return result;
    }

    private static String getUserDetailUri(String contentDisplayName) {
        return USER_DETAIL_URI + contentDisplayName;
    }

    private static String getPageUri(long pageId) {
        return "/pages/viewpage.action?pageId=" + pageId;
    }

    private String getCommentUri(@Nullable Long commentId) {
        Comment commentLatestVersion;
        ContentEntityObject commentLastVersionContainer;
        ContentEntityObject container;
        Comment comment = commentId != null ? this.commentManager.getComment(commentId.longValue()) : null;
        ContentEntityObject contentEntityObject = container = comment != null ? comment.getContainer() : null;
        if (comment == null) {
            return DISPLAY_URI_PART.concat(String.join((CharSequence)"/", "unknown", "unknown"));
        }
        if (container == null && (commentLastVersionContainer = (commentLatestVersion = (Comment)comment.getLatestVersion()).getContainer()) != null) {
            return commentLastVersionContainer.getUrlPath();
        }
        return comment.getUrlPath();
    }

    private String getSpaceUri(@Nullable String contentDisplayName, @Nullable Long spaceId) {
        Space space = spaceId != null ? this.spaceManager.getSpace(spaceId.longValue()) : null;
        return space != null ? space.getUrlPath() : DISPLAY_URI_PART.concat(contentDisplayName);
    }

    private String getAttachmentUri(String contentIdStr, String contentDisplayName) {
        String result;
        Attachment attachment;
        Long pageId = null;
        Long attachmentId = null;
        Integer attachmentVersion = null;
        Integer slide = null;
        Matcher matcher = Pattern.compile(REGEXP_ATTACHMENT_CONTENT_ID).matcher(contentIdStr);
        if (matcher.find()) {
            pageId = Longs.tryParse(matcher.group("pageId"));
            attachmentId = Longs.tryParse(matcher.group("attachment"));
            attachmentVersion = NumberUtils.parseInt(matcher.group("attachmentVer"));
            slide = NumberUtils.parseInt(matcher.group("slide"));
        }
        Attachment attachment2 = attachment = attachmentId != null ? this.attachmentManager.getAttachment(attachmentId.longValue()) : null;
        if (attachment != null && attachmentVersion != null) {
            attachment = this.attachmentManager.getAttachment(attachment.getContainer(), attachment.getFileName(), attachmentVersion.intValue());
        }
        if (attachment == null) {
            result = this.createContentViewUriForDeletedAttachmentOrSlide(pageId, contentDisplayName, attachmentVersion, slide);
        } else if (slide != null) {
            result = ConfluenceContentTypeService.createUriForSlide(attachment, slide);
        } else {
            result = attachment.getDownloadPath();
            if (attachmentVersion == null) {
                result = result.split("\\?")[0];
            }
        }
        return result;
    }

    private String createContentViewUriForDeletedAttachmentOrSlide(long pageId, String filename, @Nullable Integer version, @Nullable Integer slide) {
        String result;
        if (slide == null) {
            result = DOWNLOAD_ATTACHMENT_URI_PART.concat(String.valueOf(pageId)).concat("/").concat(RequestUtils.encode(filename));
            if (version != null) {
                result = result.concat("?version=").concat(String.valueOf(version));
            }
        } else {
            result = ConfluenceContentTypeService.createUriForSlide(filename, pageId, version, slide);
        }
        return result;
    }

    private static String createUriForSlide(Attachment attachment, int slide) {
        return ConfluenceContentTypeService.createUriForSlide(attachment.getFileName(), attachment.getContainer().getId(), attachment.getVersion(), slide);
    }

    private static String createUriForSlide(String attachmentFilename, long pageId, int attachmentVersion, int slide) {
        return "/plugins/servlet/pptslide".concat("?").concat("attachment").concat("=").concat(attachmentFilename).concat("&").concat("pageId").concat("=").concat(String.valueOf(pageId)).concat("&").concat("slide").concat("=").concat(String.valueOf(slide)).concat("&").concat("attachmentVer").concat("=").concat(String.valueOf(attachmentVersion));
    }

    private String getMacroUri(String contentIdStr) {
        String result = null;
        String[] contentIdValues = contentIdStr != null ? contentIdStr.split("\\".concat("|")) : null;
        String contentId = contentIdValues != null ? contentIdValues[0] : null;
        Long contentIdLong = contentId != null ? Long.valueOf(contentId) : null;
        Comment comment = contentId != null ? this.commentManager.getComment(contentIdLong.longValue()) : null;
        result = comment != null ? this.getCommentUri(contentIdLong) : ConfluenceContentTypeService.getPageUri(contentIdLong);
        return result;
    }

    @Override
    public Set<ContentType> getContentTypes() {
        HashSet<ContentType> contentTypes = Sets.newHashSet(ConfluenceContentType.values());
        contentTypes.addAll(Arrays.asList(CommonContentType.values()));
        return contentTypes;
    }

    @Override
    public Set<ContentType> getAllContentTypesForUi() {
        return this.getContentTypes();
    }
}

