/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.common.rest;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ServiceResponse {
    private final int statusCode;
    private final Object entity;
    private final Map<String, String> headers;

    public ServiceResponse(int statusCode, Object entity, Map<String, String> headers) {
        this.statusCode = statusCode;
        this.entity = entity;
        this.headers = headers != null ? Collections.unmodifiableMap(new HashMap<String, String>(headers)) : Collections.emptyMap();
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Object getEntity() {
        return this.entity;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public static Builder status(int statusCode) {
        return new Builder(statusCode);
    }

    public static Builder ok() {
        return new Builder(200);
    }

    public static Builder serverError() {
        return new Builder(500);
    }

    public static Builder ok(Object entity) {
        return new Builder(200).entity(entity);
    }

    public static class Builder {
        private int statusCode;
        private Object entity;
        private Map<String, String> headers = new HashMap<String, String>();

        private Builder(int statusCode) {
            this.statusCode = statusCode;
        }

        public Builder entity(Object entity) {
            this.entity = entity;
            return this;
        }

        public Builder header(String name, String value) {
            this.headers.put(name, value);
            return this;
        }

        public ServiceResponse build() {
            return new ServiceResponse(this.statusCode, this.entity, this.headers);
        }

        public Builder status(int statusCode) {
            return new Builder(statusCode);
        }
    }
}

