/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.common.rest;

import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserKey;
import com.enhancera.accesslog.common.Action;
import com.enhancera.accesslog.common.config.Config;
import com.enhancera.accesslog.common.config.ConfigService;
import com.enhancera.accesslog.common.config.ConfigUpdateService;
import com.enhancera.accesslog.common.eventsconfig.ContentTypeActionsParser;
import com.enhancera.accesslog.common.rest.ServiceResponse;
import com.enhancera.accesslog.common.servlet.GenericHttpRequest;
import com.enhancera.accesslog.common.servlet.IpResolver;
import com.enhancera.accesslog.common.util.FileUtils;
import com.enhancera.accesslog.common.util.FormattingLogger;
import com.enhancera.accesslog.common.util.UserUtils;
import com.google.common.collect.ImmutableCollection;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class ConfigRestResourceExecutor {
    private static final FormattingLogger log = FormattingLogger.getLogger(ConfigRestResourceExecutor.class);
    private final UserUtils userUtils;
    private final FileUtils fileUtils;
    private final ConfigService configService;
    private final ConfigUpdateService configUpdateService;
    private final Executor executor = Executors.newSingleThreadExecutor();
    private final TransactionTemplate transactionTemplate;
    private final ContentTypeActionsParser contentTypeActionsParser;
    private final IpResolver ipResolver;

    public ConfigRestResourceExecutor(UserUtils userUtils, FileUtils fileUtils, ConfigService configService, ConfigUpdateService configUpdateService, TransactionTemplate transactionTemplate, ContentTypeActionsParser contentTypeActionsParser, IpResolver ipResolver) {
        this.userUtils = userUtils;
        this.fileUtils = fileUtils;
        this.configService = configService;
        this.configUpdateService = configUpdateService;
        this.transactionTemplate = transactionTemplate;
        this.contentTypeActionsParser = contentTypeActionsParser;
        this.ipResolver = ipResolver;
    }

    public ServiceResponse getConfig() {
        if (!this.userUtils.isAdmin()) {
            log.error("User %s is not authorized to view configuration.", this.userUtils.getRemoteUserKey().getStringValue());
            return ServiceResponse.serverError().status(403).build();
        }
        Config config = this.configService.getConfig();
        config.setEnabledContentTypeActions(this.contentTypeActionsParser.parseContentTypeActionsMapForUI(config.getEnabledContentTypeActions()));
        log.debug("Loaded config %s", config);
        return ServiceResponse.ok(config).build();
    }

    public ServiceResponse setConfig(int retentionPeriod, int numberOfRecordsPerPage, Set<String> sensitiveFields, boolean writeToSyslog, String syslogHost, Integer syslogFacility, Integer syslogLevel, boolean writeToFile, String filePath, String eventsConfigMapJson, GenericHttpRequest request) {
        if (!this.userUtils.isAdmin()) {
            log.error("User %s is not authorized to edit configuration.", this.userUtils.getRemoteUserKey().getStringValue());
            return ServiceResponse.serverError().status(403).build();
        }
        String ipAddress = this.ipResolver.extractIpAddress(request);
        UserKey userKey = this.userUtils.getRemoteUserKey();
        Config newConfig = new Config(sensitiveFields);
        newConfig.setRetentionPeriod(retentionPeriod);
        newConfig.setNumberOfRecordsPerPage(numberOfRecordsPerPage);
        newConfig.setWriteToSyslog(writeToSyslog);
        newConfig.setSyslogHost(syslogHost);
        newConfig.setSyslogFacility(syslogFacility != null ? syslogFacility : -1);
        newConfig.setSyslogLevel(syslogLevel != null ? syslogLevel : -1);
        newConfig.setWriteToFile(writeToFile);
        newConfig.setFilePath(filePath);
        newConfig.setEnabledContentTypeActions(this.parseEventsConfigMapJson(eventsConfigMapJson));
        List<String> errors = this.validate(newConfig);
        if (errors.isEmpty()) {
            this.executor.execute(() -> this.transactionTemplate.execute(() -> {
                this.configUpdateService.updateConfig(newConfig, userKey, ipAddress);
                return null;
            }));
        }
        return ServiceResponse.ok(errors).build();
    }

    private Map<String, List<Action>> parseEventsConfigMapJson(String eventsConfigJson) {
        Gson gson = new Gson();
        Config config = gson.fromJson(eventsConfigJson, Config.class);
        return this.contentTypeActionsParser.parseContentTypeActionsMapFromUI(config.getEnabledContentTypeActions());
    }

    private List<String> validate(Config config) {
        Integer syslogLevel;
        ArrayList<String> errors = new ArrayList<String>();
        if (config.isWriteToFile() && !this.fileUtils.initFile(config.getFilePath())) {
            errors.add("Invalid log file path.");
        }
        if ((syslogLevel = Integer.valueOf(config.getSyslogLevel())) == -1 || ((ImmutableCollection)((Object)ConfigService.OLD_TO_NEW_SEVERITY_MAP.keySet())).contains(syslogLevel)) {
            errors.add("Severity and facility lists were updated after the latest plugin version installation. Please <a href=\"javascript:window.location.reload(true)\">reload the page</a> and try again.");
        }
        return errors;
    }
}

