/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.javax.rest;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.enhancera.accesslog.common.rest.ConfigRestResourceExecutor;
import com.enhancera.accesslog.common.util.FormattingLogger;
import com.enhancera.accesslog.javax.JavaxHttpRequestAdapter;
import com.enhancera.accesslog.javax.rest.JavaxResponseAdapter;
import java.util.Set;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/config")
@AdminOnly
public class JavaxConfigRestResource {
    private static final FormattingLogger log = FormattingLogger.getLogger(JavaxConfigRestResource.class);
    private final ConfigRestResourceExecutor executor;

    public JavaxConfigRestResource(ConfigRestResourceExecutor executor) {
        this.executor = executor;
    }

    @GET
    @Produces(value={"application/json", "application/xml"})
    public Response getConfig() {
        return JavaxResponseAdapter.toJavax(this.executor.getConfig());
    }

    @POST
    @ReadOnlyAccessAllowed
    @Produces(value={"application/json", "application/xml"})
    public Response setConfig(@FormParam(value="retentionPeriod") int retentionPeriod, @FormParam(value="numberOfRecordsPerPage") int numberOfRecordsPerPage, @FormParam(value="sensitiveFields") Set<String> sensitiveFields, @FormParam(value="writeToSyslog") boolean writeToSyslog, @FormParam(value="syslogHost") String syslogHost, @Nullable @FormParam(value="syslogFacility") Integer syslogFacility, @Nullable @FormParam(value="syslogLevel") Integer syslogLevel, @FormParam(value="writeToFile") boolean writeToFile, @FormParam(value="filePath") String filePath, @FormParam(value="eventsConfigMap") String eventsConfigMapJson, @Context HttpServletRequest request) {
        return JavaxResponseAdapter.toJavax(this.executor.setConfig(retentionPeriod, numberOfRecordsPerPage, sensitiveFields, writeToSyslog, syslogHost, syslogFacility, syslogLevel, writeToFile, filePath, eventsConfigMapJson, new JavaxHttpRequestAdapter(request)));
    }
}

