/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.confluence.util;

import com.atlassian.audit.api.AuditConsumer;
import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.audit.entity.AuditAuthor;
import com.atlassian.audit.entity.AuditEntity;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.ChangedValue;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.user.UserKey;
import com.cloudbees.syslog.Facility;
import com.cloudbees.syslog.Severity;
import com.enhancera.accesslog.common.config.Config;
import com.enhancera.accesslog.common.util.DefaultAuditLogger;
import com.enhancera.accesslog.common.util.UserFriendlyUtils;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public class ConfluenceDefaultAuditLogger
implements DefaultAuditLogger {
    private static final Logger log = Logger.getLogger(ConfluenceDefaultAuditLogger.class);
    private static final CoverageArea ACCESS_LOG_AUDIT_EVENT_COVERAGE_AREA = CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION;
    private static final CoverageLevel ACCESS_LOG_AUDIT_EVENT_COVERAGE_LEVEL = CoverageLevel.BASE;
    private final AuditConsumer auditConsumer;
    private final UserAccessor userAccessor;
    private final UserFriendlyUtils userFriendlyUtils;

    public ConfluenceDefaultAuditLogger(AuditConsumer auditConsumer, UserAccessor userAccessor, UserFriendlyUtils userFriendlyUtils) {
        this.auditConsumer = auditConsumer;
        this.userAccessor = userAccessor;
        this.userFriendlyUtils = userFriendlyUtils;
    }

    @Override
    public void logRecordsDeletedEvent(UserKey userKey, String ipAddress) {
        ConfluenceUser confluenceUser = this.userAccessor.getUserByKey(userKey);
        AuditAuthor auditAuthor = AuditAuthor.builder().id(userKey.getStringValue()).name(confluenceUser.getFullName()).type("admin").build();
        AuditType auditType = new AuditType(ACCESS_LOG_AUDIT_EVENT_COVERAGE_AREA, "Apps", "All Access Log plugin records deleted", ACCESS_LOG_AUDIT_EVENT_COVERAGE_LEVEL);
        AuditResource affectedObject = AuditResource.builder((String)"Access Log for Confluence", (String)"App").build();
        AuditAttribute ipAttribute = new AuditAttribute("IP Address", ipAddress);
        AuditEntity.Builder auditEntity = AuditEntity.builder((AuditType)auditType).author(auditAuthor).affectedObject(affectedObject).extraAttribute(ipAttribute);
        try {
            Method acceptAuditRecordsMethod = this.auditConsumer.getClass().getMethod("accept", List.class);
            acceptAuditRecordsMethod.invoke((Object)this.auditConsumer, ImmutableList.of(auditEntity.build()));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.error((Object)"Unable to log \"Access Log for Confluence records deleted\" event to audit log", (Throwable)e);
        }
    }

    @Override
    public void logConfigUpdateRecord(UserKey userKey, Config newConfig, Config oldConfig, @Nullable String ipAddress) {
        List<ChangedValue> changedValues = this.getConfigChangedValues(newConfig, oldConfig);
        if (changedValues.isEmpty()) {
            return;
        }
        ConfluenceUser confluenceUser = this.userAccessor.getUserByKey(userKey);
        AuditAuthor auditAuthor = AuditAuthor.builder().id(userKey.getStringValue()).name(confluenceUser.getFullName()).type("admin").build();
        AuditType auditType = new AuditType(ACCESS_LOG_AUDIT_EVENT_COVERAGE_AREA, "Apps", "Configuration updated", ACCESS_LOG_AUDIT_EVENT_COVERAGE_LEVEL);
        AuditResource affectedObject = AuditResource.builder((String)"Access Log for Confluence", (String)"App").build();
        AuditEntity.Builder auditEntity = AuditEntity.builder((AuditType)auditType).author(auditAuthor).affectedObject(affectedObject);
        if (ipAddress != null) {
            AuditAttribute ipAttribute = new AuditAttribute("IP Address", ipAddress);
            auditEntity.extraAttribute(ipAttribute);
        }
        for (ChangedValue changedValue : changedValues) {
            auditEntity.changedValue(changedValue);
        }
        try {
            Method acceptAuditRecordsMethod = this.auditConsumer.getClass().getMethod("accept", List.class);
            acceptAuditRecordsMethod.invoke((Object)this.auditConsumer, ImmutableList.of(auditEntity.build()));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.error((Object)"Unable to log Access Log for Confluence configuration update event to audit log", (Throwable)e);
        }
    }

    private List<ChangedValue> getConfigChangedValues(Config newConfig, Config oldConfig) {
        ArrayList<ChangedValue> changedValues = new ArrayList<ChangedValue>();
        ConfluenceDefaultAuditLogger.addChangedItem(changedValues, "Retention period(days)", UserFriendlyUtils.parseConfigRetentionPeriod(oldConfig.getRetentionPeriod()), UserFriendlyUtils.parseConfigRetentionPeriod(newConfig.getRetentionPeriod()));
        ConfluenceDefaultAuditLogger.addChangedItem(changedValues, "Records per page", oldConfig.getNumberOfRecordsPerPage(), newConfig.getNumberOfRecordsPerPage());
        ConfluenceDefaultAuditLogger.addChangedItem(changedValues, "Write to syslog", UserFriendlyUtils.parseBoolean(oldConfig.isWriteToSyslog()), UserFriendlyUtils.parseBoolean(newConfig.isWriteToSyslog()));
        ConfluenceDefaultAuditLogger.addChangedItem(changedValues, "Syslog host", UserFriendlyUtils.emptyMarkerIfNullOrBlank(oldConfig.getSyslogHost()), UserFriendlyUtils.emptyMarkerIfNullOrBlank(newConfig.getSyslogHost()));
        ConfluenceDefaultAuditLogger.addChangedItem(changedValues, "Syslog facility", Facility.fromNumericalCode(oldConfig.getSyslogFacility()).name().toLowerCase(), Facility.fromNumericalCode(newConfig.getSyslogFacility()).name().toLowerCase());
        ConfluenceDefaultAuditLogger.addChangedItem(changedValues, "Syslog severity level", UserFriendlyUtils.capitalize(Severity.fromNumericalCode(oldConfig.getSyslogLevel()).name()), UserFriendlyUtils.capitalize(Severity.fromNumericalCode(newConfig.getSyslogLevel()).name()));
        ConfluenceDefaultAuditLogger.addChangedItem(changedValues, "Write to file", UserFriendlyUtils.parseBoolean(oldConfig.isWriteToFile()), UserFriendlyUtils.parseBoolean(newConfig.isWriteToFile()));
        ConfluenceDefaultAuditLogger.addChangedItem(changedValues, "File path", UserFriendlyUtils.emptyMarkerIfNullOrBlank(oldConfig.getFilePath()), UserFriendlyUtils.emptyMarkerIfNullOrBlank(newConfig.getFilePath()));
        ConfluenceDefaultAuditLogger.addChangedItem(changedValues, "Tracked events", this.userFriendlyUtils.parseEnabledContentTypeActionsMapToUiFriendlyString(oldConfig.getEnabledContentTypeActions()), this.userFriendlyUtils.parseEnabledContentTypeActionsMapToUiFriendlyString(newConfig.getEnabledContentTypeActions()));
        return changedValues;
    }

    private static <T> void addChangedItem(List<ChangedValue> changedValues, String changedParamName, T oldValue, T newValue) {
        if (!Objects.equals(oldValue, newValue)) {
            changedValues.add(new ChangedValue(changedParamName, String.valueOf(oldValue), String.valueOf(newValue)));
        }
    }
}

