/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.confluence.recordparser;

import com.atlassian.confluence.pages.AbstractPage;
import com.enhancera.accesslog.common.AccessRecord;
import com.enhancera.accesslog.common.Action;
import com.enhancera.accesslog.common.RequestData;
import com.enhancera.accesslog.common.ResponseData;
import com.enhancera.accesslog.common.recordparser.UriMatchingNonHeadParser;
import com.enhancera.accesslog.common.util.RequestUtils;
import com.enhancera.accesslog.confluence.util.ConfluenceContentUtils;
import com.enhancera.accesslog.confluence.util.ConfluenceRecordsParserUtils;
import com.google.common.collect.ImmutableList;
import java.util.Optional;
import org.apache.commons.lang3.math.NumberUtils;

public class AttachmentViewOrDownloadRecordParser
extends UriMatchingNonHeadParser {
    private static final String ATTACHMENT_FILENAME = "attachmentFilename";
    private static final String ACCEPT_HEADER = "accept";
    private static final String ACCEPT_HEADER_DOWNLOAD = "text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.9";
    private static final String ACCEPT_HEADER_IMAGE_PREVIEW = "image/avif,image/webp,image/apng,image/*,*/*;q=0.8";
    private static final String REFERER_HEADER = "referer";
    private static final String REFERER_HEADER_PREVIEW_SUBSTR = "viewpageattachments.action";
    private static final String REFERER_HEADER_PREVIEW_MEDIAVIEWER_SUBSTR = "mediaviewer";
    private static final String REFERER_HEADER_PAGE_DISPLAY = "display";
    private final ConfluenceRecordsParserUtils recordsParserUtils;
    private final ConfluenceContentUtils contentUtils;

    public AttachmentViewOrDownloadRecordParser(ConfluenceRecordsParserUtils recordsParserUtils, ConfluenceContentUtils contentUtils) {
        super("/download/attachments/(?<pageId>\\d+)/(?<attachmentFilename>.+)");
        this.recordsParserUtils = recordsParserUtils;
        this.contentUtils = contentUtils;
    }

    @Override
    protected ImmutableList<AccessRecord> parse(RequestData requestData, ResponseData responseData) {
        Optional<String> attachmentFilenameOptional;
        ImmutableList<AccessRecord> result = ImmutableList.of();
        Optional<String> refererHeader = requestData.getRequestHeaderValue(REFERER_HEADER);
        if (refererHeader.isPresent() && refererHeader.get().contains(REFERER_HEADER_PAGE_DISPLAY)) {
            return result;
        }
        Optional<Long> pageId = RequestUtils.parseUriParamLong(requestData.getContextPath() + "/download/attachments/(?<pageId>\\d+)/(?<attachmentFilename>.+)", requestData.getUri(), "pageId");
        String version = requestData.getRequestParameterValue("version").orElse(null);
        int intVersion = NumberUtils.toInt(version);
        Optional<Object> page = Optional.empty();
        if (pageId.isPresent()) {
            page = this.contentUtils.getAbstractPageById(pageId.get());
        }
        if (page.isPresent() && (attachmentFilenameOptional = RequestUtils.parseUriParam(requestData.getContextPath() + "/download/attachments/(?<pageId>\\d+)/(?<attachmentFilename>.+)", requestData.getUri(), ATTACHMENT_FILENAME)).isPresent()) {
            result = this.recordsParserUtils.parseAttachmentRecords(requestData.getUserKey(), requestData.getIpAddress(), (AbstractPage)page.get(), RequestUtils.decode(attachmentFilenameOptional.get()), intVersion, AttachmentViewOrDownloadRecordParser.getAttachmentAction(requestData));
        }
        return result;
    }

    private static Action getAttachmentAction(RequestData requestData) {
        String acceptHeader = requestData.getRequestHeaderValue(ACCEPT_HEADER).orElse(null);
        if (ACCEPT_HEADER_DOWNLOAD.equals(acceptHeader)) {
            return Action.DOWNLOAD;
        }
        String refererHeader = requestData.getRequestHeaderValue(REFERER_HEADER).orElse(null);
        if (refererHeader != null) {
            if (refererHeader.contains(REFERER_HEADER_PREVIEW_MEDIAVIEWER_SUBSTR)) {
                return Action.VIEW;
            }
            if (refererHeader.contains(REFERER_HEADER_PREVIEW_SUBSTR)) {
                return ACCEPT_HEADER_IMAGE_PREVIEW.equals(acceptHeader) ? Action.VIEW : Action.DOWNLOAD;
            }
        }
        return Action.DOWNLOAD;
    }
}

