/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.confluence.recordparser.rest;

import com.enhancera.accesslog.common.AccessRecord;
import com.enhancera.accesslog.common.RequestData;
import com.enhancera.accesslog.common.ResponseData;
import com.enhancera.accesslog.confluence.recordparser.rest.BulkRestUriMatchingParser;
import com.enhancera.accesslog.confluence.util.ConfluenceApiContentRecordsParserUtils;
import com.enhancera.accesslog.confluence.util.ConfluenceContentUtils;
import com.google.common.collect.ImmutableList;
import org.apache.commons.lang3.math.NumberUtils;

public class ContentSearchRestViewRecordParser
extends BulkRestUriMatchingParser {
    private static final String PARAM_CQL = "cql";
    private static final String PARAM_CQL_CONTEXT = "cqlcontext";
    private final ConfluenceContentUtils contentUtils;
    private final ConfluenceApiContentRecordsParserUtils confluenceApiContentRecordsParserUtils;

    public ContentSearchRestViewRecordParser(ConfluenceContentUtils contentUtils, ConfluenceApiContentRecordsParserUtils confluenceApiContentRecordsParserUtils) {
        super("/rest/api/content/search/?");
        this.contentUtils = contentUtils;
        this.confluenceApiContentRecordsParserUtils = confluenceApiContentRecordsParserUtils;
    }

    @Override
    protected ImmutableList<AccessRecord> parse(RequestData requestData, ResponseData responseData) {
        ConfluenceApiContentRecordsParserUtils.addUserToThreadLocal(requestData.getUserKey());
        return this.parseRestContentSearchRecords(requestData);
    }

    ImmutableList<AccessRecord> parseRestContentSearchRecords(RequestData requestData) {
        String cql = requestData.getRequestParameterValue(PARAM_CQL).orElse(null);
        String cqlContext = requestData.getRequestParameterValue(PARAM_CQL_CONTEXT).orElse(null);
        String start = requestData.getRequestParameterValue("start").orElse(null);
        String limit = requestData.getRequestParameterValue("limit").orElse(null);
        return this.confluenceApiContentRecordsParserUtils.parseContentAccessRecords(this.contentUtils.getContentFromCqlSearch(cql, cqlContext, NumberUtils.toInt(start), NumberUtils.toInt(limit, 25)), requestData);
    }
}

