/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.common.logwriters;

import com.cloudbees.syslog.Facility;
import com.cloudbees.syslog.MessageFormat;
import com.cloudbees.syslog.Severity;
import com.cloudbees.syslog.sender.SyslogMessageSender;
import com.cloudbees.syslog.sender.UdpSyslogMessageSender;
import com.enhancera.accesslog.HostAppService;
import com.enhancera.accesslog.common.AccessRecord;
import com.enhancera.accesslog.common.config.Config;
import com.enhancera.accesslog.common.config.ConfigService;
import com.enhancera.accesslog.common.logwriters.AccessLogWriter;
import com.enhancera.accesslog.common.logwriters.LogWriterFormattingUtils;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;

public class SyslogAccessLogWriter
implements AccessLogWriter {
    private static final Logger log = Logger.getLogger(SyslogAccessLogWriter.class);
    private final HostAppService hostAppService;
    private final ConfigService configService;
    private final LogWriterFormattingUtils logWriterFormattingUtils;

    public SyslogAccessLogWriter(HostAppService hostAppService, ConfigService configService, LogWriterFormattingUtils logWriterFormattingUtils) {
        this.hostAppService = hostAppService;
        this.configService = configService;
        this.logWriterFormattingUtils = logWriterFormattingUtils;
    }

    @Override
    public void write(List<AccessRecord> events) {
        if (this.configService.getConfig().isWriteToSyslog()) {
            SyslogMessageSender syslogMessageSender = this.createSyslogMessageSender();
            events.forEach(accessRecord -> {
                try {
                    syslogMessageSender.sendMessage(this.logWriterFormattingUtils.formatRecord((AccessRecord)accessRecord));
                }
                catch (IOException e) {
                    log.error((Object)("Error occurred when writing to Syslog access record: " + accessRecord));
                }
            });
        }
    }

    private SyslogMessageSender createSyslogMessageSender() {
        Config config = this.configService.getConfig();
        UdpSyslogMessageSender messageSender = new UdpSyslogMessageSender();
        messageSender.setDefaultMessageHostname(config.getSyslogHost());
        messageSender.setDefaultAppName(this.hostAppService.getApplicationName() + "AccessLog");
        messageSender.setDefaultFacility(Facility.fromNumericalCode(config.getSyslogFacility()));
        messageSender.setDefaultSeverity(Severity.fromNumericalCode(config.getSyslogLevel()));
        messageSender.setSyslogServerHostname(config.getSyslogHost());
        messageSender.setSyslogServerPort(514);
        messageSender.setMessageFormat(MessageFormat.RFC_3164);
        return messageSender;
    }
}

