/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.common.logwriters;

import com.enhancera.accesslog.HostAppService;
import com.enhancera.accesslog.common.AccessRecord;
import com.enhancera.accesslog.common.AccessRecordFormatter;
import com.enhancera.accesslog.common.Action;
import com.enhancera.accesslog.common.CommonContentType;
import com.enhancera.accesslog.common.ao.upgrade.UpgradeService;
import com.enhancera.accesslog.common.config.ConfigService;
import com.enhancera.accesslog.common.database.DataLayer;
import com.enhancera.accesslog.common.logwriters.CompoundAccessLogWriter;
import com.enhancera.accesslog.common.logwriters.DatabaseAccessLogWriter;
import com.enhancera.accesslog.common.logwriters.FileAccessLogWriter;
import com.enhancera.accesslog.common.logwriters.LogWriterFormattingUtils;
import com.enhancera.accesslog.common.logwriters.ProxyAccessLogWriter;
import com.enhancera.accesslog.common.logwriters.SyslogAccessLogWriter;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AccessLogWriterImpl
extends ProxyAccessLogWriter {
    private final UpgradeService upgradeService;
    private final ConfigService configService;

    public AccessLogWriterImpl(HostAppService hostAppService, ConfigService configService, DataLayer dataLayer, AccessRecordFormatter accessRecordFormatter, UpgradeService upgradeService, LogWriterFormattingUtils logWriterFormattingUtils) {
        super(new CompoundAccessLogWriter(configService).add(new DatabaseAccessLogWriter(dataLayer)).add(new SyslogAccessLogWriter(hostAppService, configService, logWriterFormattingUtils)).add(new FileAccessLogWriter(configService, accessRecordFormatter)));
        this.upgradeService = upgradeService;
        this.configService = configService;
    }

    @Override
    public void write(List<AccessRecord> records) {
        if (!records.isEmpty() && this.upgradeService.isUpgradeCompleted()) {
            super.write(this.getRecordsThatShouldBeTracked(records));
        }
    }

    @VisibleForTesting
    public List<AccessRecord> getRecordsThatShouldBeTracked(List<AccessRecord> records) {
        Map<String, List<Action>> enabledContentTypeActionsMap = this.configService.getConfig().getEnabledContentTypeActions();
        ArrayList<AccessRecord> result = new ArrayList<AccessRecord>();
        for (AccessRecord accessRecord : records) {
            if (CommonContentType.ACCESS_LOG_PLUGIN_EVENT.equals(accessRecord.getContentType())) {
                result.add(accessRecord);
                continue;
            }
            List<Action> contentTypeEnabledActions = enabledContentTypeActionsMap.get(accessRecord.getContentType().getName());
            if (contentTypeEnabledActions == null || !contentTypeEnabledActions.contains((Object)accessRecord.getAction())) continue;
            result.add(accessRecord);
        }
        return result;
    }
}

