/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.jakarta.util;

import com.enhancera.accesslog.common.util.FormattingLogger;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableListMultimap;
import jakarta.servlet.http.HttpServletRequest;
import java.net.URI;
import java.util.Enumeration;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class JakartaRequestUtils {
    private static final FormattingLogger log = FormattingLogger.getLogger(JakartaRequestUtils.class);

    private JakartaRequestUtils() {
    }

    private static URI getUri(HttpServletRequest request) {
        StringBuilder builder = new StringBuilder(request.getRequestURI());
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    public static ImmutableListMultimap<String, String> createRequestHeadersMultimap(HttpServletRequest req) {
        ArrayListMultimap<String, String> result = ArrayListMultimap.create();
        Enumeration headerNames = req.getHeaderNames();
        if (headerNames != null) {
            while (headerNames.hasMoreElements()) {
                String name = (String)headerNames.nextElement();
                Enumeration headerValues = req.getHeaders(name);
                if (headerValues == null) continue;
                while (headerValues.hasMoreElements()) {
                    result.put(name, (String)headerValues.nextElement());
                }
            }
        }
        return ImmutableListMultimap.copyOf(result);
    }

    public static ImmutableListMultimap<String, String> createRequestParametersMultimap(HttpServletRequest req) {
        Map parameterMap = req.getParameterMap();
        ArrayListMultimap<String, String> result = ArrayListMultimap.create();
        if (parameterMap != null) {
            for (Map.Entry entry : parameterMap.entrySet()) {
                if (entry == null) continue;
                for (String value : (String[])entry.getValue()) {
                    result.put((String)entry.getKey(), value);
                }
            }
        }
        return ImmutableListMultimap.copyOf(result);
    }

    public static Optional<String> extractIpAddress(HttpServletRequest httpRequest) {
        if (httpRequest == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(JakartaRequestUtils.extractProxyIpAddress(httpRequest).orElse(httpRequest.getRemoteAddr()));
    }

    private static Optional<String> extractProxyIpAddress(HttpServletRequest httpRequest) {
        Optional<String> result = JakartaRequestUtils.getClientIpHeaderValue("X-Forwarded-For", httpRequest);
        if (!result.isPresent()) {
            result = JakartaRequestUtils.getClientIpHeaderValue("X-Client-IP", httpRequest);
        }
        return result;
    }

    private static Optional<String> getClientIpHeaderValue(String headerName, HttpServletRequest httpRequest) {
        Enumeration requestHeaders = httpRequest.getHeaders(headerName);
        if (requestHeaders != null) {
            while (requestHeaders.hasMoreElements()) {
                String headerValue = (String)requestHeaders.nextElement();
                if (StringUtils.isBlank(headerValue)) continue;
                return Optional.of("X-Forwarded-For".equals(headerName) && headerValue.contains(",") ? headerValue.split(",")[0].trim() : headerValue);
            }
        }
        return Optional.empty();
    }
}

