/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.common.util;

import com.atlassian.sal.api.message.I18nResolver;
import com.enhancera.accesslog.common.Action;
import com.enhancera.accesslog.common.ContentType;
import com.enhancera.accesslog.common.eventsconfig.DefaultEventsConfigProvider;
import com.enhancera.accesslog.common.util.CollectionUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class UserFriendlyUtils {
    private static final String EMPTY_VALUE = "<empty>";
    private final I18nResolver i18nResolver;
    private final DefaultEventsConfigProvider eventsConfigProvider;

    public UserFriendlyUtils(I18nResolver i18nResolver, DefaultEventsConfigProvider eventsConfigProvider) {
        this.i18nResolver = i18nResolver;
        this.eventsConfigProvider = eventsConfigProvider;
    }

    public static String parseBoolean(boolean value) {
        return value ? "Yes" : "No";
    }

    public static String emptyMarkerIfNullOrBlank(String value) {
        return StringUtils.isBlank(value) ? EMPTY_VALUE : value;
    }

    public static String capitalize(String value) {
        if (StringUtils.isBlank(value)) {
            return EMPTY_VALUE;
        }
        return value.substring(0, 1).toUpperCase() + value.substring(1).toLowerCase().replace('_', ' ');
    }

    public static String parseConfigRetentionPeriod(int retentionPeriod) {
        return retentionPeriod == 0 ? "unlimited" : String.valueOf(retentionPeriod);
    }

    public String parseEnabledContentTypeActionsMapToUiFriendlyString(@Nullable Map<String, List<Action>> contentTypeActions) {
        Map<ContentType, List<Action>> contentTypeActionsOrderedAsInUi = this.createOrderedAsInUiContentTypeActionsMap(contentTypeActions);
        if (CollectionUtils.isNullOrEmpty(contentTypeActionsOrderedAsInUi)) {
            return EMPTY_VALUE;
        }
        ArrayList<String> uiAllContentTypeActions = new ArrayList<String>();
        StringBuilder uiContentTypeActionsBuilder = new StringBuilder();
        for (Map.Entry<ContentType, List<Action>> entry : contentTypeActionsOrderedAsInUi.entrySet()) {
            ContentType contentType = entry.getKey();
            String contentTypeUiFriendlyName = this.i18nResolver.getText(contentType.getDisplayNameProperty());
            uiContentTypeActionsBuilder.append(contentTypeUiFriendlyName).append(": ");
            List uiActionValuesForContentType = entry.getValue().stream().map(action -> this.i18nResolver.getText(action.getDisplayNameProperty())).collect(Collectors.toList());
            uiContentTypeActionsBuilder.append("[").append(String.join((CharSequence)", ", uiActionValuesForContentType)).append("]");
            uiAllContentTypeActions.add(uiContentTypeActionsBuilder.toString());
            uiContentTypeActionsBuilder.setLength(0);
        }
        return String.join((CharSequence)", ", uiAllContentTypeActions);
    }

    private Map<ContentType, List<Action>> createOrderedAsInUiContentTypeActionsMap(@Nullable Map<String, List<Action>> contentTypeActions) {
        if (CollectionUtils.isNullOrEmpty(contentTypeActions)) {
            return Collections.emptyMap();
        }
        LinkedHashMap<ContentType, List<Action>> orderedContentTypeActionsMap = new LinkedHashMap<ContentType, List<Action>>();
        for (ContentType contentType : this.eventsConfigProvider.getAllContentTypeActionsMapForUi().keySet()) {
            String contentTypeName = contentType.getName();
            List<Action> actions = contentTypeActions.get(contentTypeName);
            if (CollectionUtils.isNullOrEmpty(actions)) continue;
            orderedContentTypeActionsMap.put(contentType, actions);
        }
        return orderedContentTypeActionsMap;
    }
}

