/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.common.logwriters;

import com.enhancera.accesslog.common.AccessRecord;
import com.enhancera.accesslog.common.logwriters.AccessLogWriter;
import com.enhancera.accesslog.common.logwriters.LogWriterFormattingUtils;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class LoggingAccessLogWriter
implements AccessLogWriter {
    private static final Level DEFAULT_LEVEL = Level.INFO;
    private final String category;
    private LogWriterFormattingUtils logWriterFormattingUtils;

    public LoggingAccessLogWriter(String category, LogWriterFormattingUtils logWriterFormattingUtils) {
        this.category = category;
        this.logWriterFormattingUtils = logWriterFormattingUtils;
    }

    public Logger getLogger() {
        Logger logger = Logger.getLogger((String)this.category);
        logger.setLevel(this.getLevel());
        return logger;
    }

    public Level getLevel() {
        return DEFAULT_LEVEL;
    }

    @Override
    public void write(List<AccessRecord> records) {
        Logger logger = this.getLogger();
        Level level = this.getLevel();
        for (AccessRecord record : records) {
            logger.log((Priority)level, (Object)this.logWriterFormattingUtils.formatRecord(record));
        }
    }
}

