/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.jakarta;

import com.enhancera.accesslog.common.servlet.HttpStatus;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;

public class StatusExposingServletResponse
extends HttpServletResponseWrapper {
    private int statusCode = HttpStatus.OK.code();
    private ListMultimap<String, String> headers = ArrayListMultimap.create();

    public StatusExposingServletResponse(HttpServletResponse response) {
        super(response);
    }

    public void setStatus(int sc) {
        super.setStatus(sc);
        this.statusCode = sc;
    }

    public void setHeader(String name, String value) {
        super.setHeader(name, value);
        this.headers.put(name, value);
    }

    public void addHeader(String name, String value) {
        super.setHeader(name, value);
        this.headers.put(name, value);
    }

    public ImmutableListMultimap<String, String> getAllHeaders() {
        return ImmutableListMultimap.copyOf(this.headers);
    }

    public void sendError(int sc) throws IOException {
        try {
            super.sendError(sc);
        }
        catch (IllegalStateException ex) {
            super.setStatus(sc);
        }
        this.statusCode = sc;
    }

    public void sendError(int sc, String msg) throws IOException {
        try {
            super.sendError(sc, msg);
        }
        catch (IllegalStateException ex) {
            super.setStatus(sc);
        }
        this.statusCode = sc;
    }

    public void sendRedirect(String location) throws IOException {
        this.statusCode = HttpStatus.MOVED_TEMPORARILY.code();
        super.sendRedirect(location);
    }

    public void reset() {
        super.reset();
        this.statusCode = 200;
    }

    public int getStatusCode() {
        return this.statusCode;
    }
}

