/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.javax;

import com.atlassian.sal.api.user.UserKey;
import com.enhancera.accesslog.common.RequestData;
import com.enhancera.accesslog.common.rest.HttpMethod;
import com.enhancera.accesslog.javax.util.JavaxRequestUtils;
import com.google.common.collect.ImmutableListMultimap;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.joda.time.DateTime;

public class JavaxRequestDataFactory {
    private JavaxRequestDataFactory() {
    }

    public static RequestData create(HttpServletRequest httpRequest, UserKey userKey, @Nullable String body) {
        String ipAddress = JavaxRequestUtils.extractIpAddress(httpRequest).orElse(null);
        DateTime time = DateTime.now();
        HttpMethod method = HttpMethod.fromString(httpRequest.getMethod());
        String uri = httpRequest.getRequestURI();
        String contextPath = httpRequest.getContextPath();
        String pathInfo = httpRequest.getPathInfo();
        ImmutableListMultimap<String, String> requestParameters = JavaxRequestUtils.createRequestParametersMultimap(httpRequest);
        ImmutableListMultimap<String, String> requestHeaders = JavaxRequestUtils.createRequestHeadersMultimap(httpRequest);
        return RequestData.create(userKey, ipAddress, time, method, uri, contextPath, Optional.ofNullable(pathInfo), Optional.ofNullable(body), requestParameters, requestHeaders);
    }
}

