/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.confluence.recordparser.rest;

import com.enhancera.accesslog.common.AccessRecord;
import com.enhancera.accesslog.common.RequestData;
import com.enhancera.accesslog.common.ResponseData;
import com.enhancera.accesslog.common.recordparser.UriMatchingParser;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class RestUriMatchingParser
extends UriMatchingParser {
    private static final String PARAM_EXPAND = "expand";
    private static final String BODY = "body.";
    private static final Set<String> EXPAND_BODY_VALUES = ImmutableSet.of("editor", "view", "export_view", "styled_view", "storage", "anonymous_export_view", new String[0]).stream().map("body."::concat).collect(Collectors.collectingAndThen(Collectors.toSet(), ImmutableSet::copyOf));
    private final boolean isExpandBodyStorageRequired;

    public RestUriMatchingParser(String uriRegexp, boolean isExpandBodyStorageRequired) {
        super(uriRegexp);
        this.isExpandBodyStorageRequired = isExpandBodyStorageRequired;
    }

    @Override
    public ImmutableList<AccessRecord> parseRecords(RequestData requestData, ResponseData responseData) {
        if (this.isExpandBodyStorageRequired) {
            HashSet<String> expandValues;
            Optional<String> expandValue = requestData.getRequestParameterValue(PARAM_EXPAND);
            HashSet<String> hashSet = expandValues = expandValue.isPresent() ? Sets.newHashSet(expandValue.get().split(",")) : null;
            if (expandValues == null || Collections.disjoint(expandValues, EXPAND_BODY_VALUES)) {
                return ImmutableList.of();
            }
        }
        return super.parseRecords(requestData, responseData);
    }
}

